package ru.yandex.autotests.direct.api.adgroups.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author buhter
 * Date 17.09.15
 * https://st.yandex-team.ru/TESTIRT-7178
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Issue("https://st.yandex-team.ru/DIRECT-44780")
@RunWith(Parameterized.class)
public class AdGroupsAddTextGroupToNonTextCampaignTest {
    private static final String client = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public CampaignsType campaignsType;

    @Parameterized.Parameter(1)
    public Notification error;

    @Parameterized.Parameters(name = "тип кампании - {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {CampaignsType.GEO, new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)},
                {CampaignsType.MCB, new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)},
                {CampaignsType.MOBILE_CONTENT,
                        new Notification(6000, Api5ErrorDetails.ADGROUP_TYPE_DOESNT_MATCH_CAMPAIGN_TYPE)},
                {CampaignsType.PERFORMANCE,
                        new Notification(6000, Api5ErrorDetails.ADGROUP_TYPE_DOESNT_MATCH_CAMPAIGN_TYPE)},
                {CampaignsType.MCBANNER, new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)},
                {CampaignsType.DYNAMIC,
                        new Notification(6000, Api5ErrorDetails.ADGROUP_TYPE_DOESNT_MATCH_CAMPAIGN_TYPE)},
                {CampaignsType.WALLET, new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)},
                {CampaignsType.CPM_BANNER,
                        new Notification(6000, Api5ErrorDetails.ADGROUP_TYPE_DOESNT_MATCH_CAMPAIGN_TYPE)},
                {CampaignsType.CPM_DEALS,
                        new Notification(6000, Api5ErrorDetails.ADGROUP_TYPE_DOESNT_MATCH_CAMPAIGN_TYPE)},
        };
        return Arrays.asList(data);
    }

    private static Long campaignId;

    @Before
    @Step("Подготовка тестовых данных")
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        api.userSteps.campaignFakeSteps().setType(campaignId, campaignsType);
    }

    @Test
    public void addTextGroupToMobileContentCampaign() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap()
                                .defaultAdGroupAddItem(campaignId)
                ),
                ExpectedResult.errors(error)
        );
    }
}
