package ru.yandex.autotests.direct.api.adgroups.add;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.adgroups.AddResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.utils.model.Locale;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.CoreMatchers.notNullValue;
import static org.hamcrest.Matchers.contains;
import static org.hamcrest.Matchers.either;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Author pavryabov
 * Date 14.10.14
 * https://jira.yandex-team.ru/browse/TESTIRT-2022
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@RunWith(Parameterized.class)
public class AdGroupsLocaleTest {

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @SuppressWarnings("DefaultAnnotationParam")
    @Parameterized.Parameter(0)
    public String locale;

    @Parameterized.Parameters(name = "locale = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Locale.ENGLISH.getName()},
                {Locale.RUSSIAN.getName()}
        };
        return Arrays.asList(data);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
    }

    @Test
    public void localeTest() {
        AddRequestMap args = new AddRequestMap()
                .withAdGroups(new AdGroupAddItemMap().defaultAdGroupAddItem(0L));

        // TODO DIRECT-75345 perlError будет не нужен, надо вернуть обратно shouldGetResultOnAdd

        AddResponse response = api.locale(locale).userSteps.adGroupsSteps().defaultClientV5()
                .invokeMethod(ServiceNames.AD_GROUPS, null, Action.ADD, args.getBean());

        assumeThat("получен ответ сервиса", response, notNullValue());

        Notification perlError = new Notification(locale, 5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER,
                capitalize(AdGroupAddItemMap.CAMPAIGN_ID));

        Notification javaError = new Notification(locale, 5005, Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                capitalize(AdGroupAddItemMap.CAMPAIGN_ID));

        assertThat("содержание результатов соответствует ожидаемому", response.getAddResults(),
                contains(either(ExpectedResult.errors(perlError).getActionResultMatcher())
                        .or(ExpectedResult.errors(javaError).getActionResultMatcher())));

    }

}
