package ru.yandex.autotests.direct.api.adgroups.add;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Author buhter
 * Date 01.12.2015
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
public class AddAdGroupStatusesTest {

    private static final String client = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static PhrasesRecord adGroup;

    @Rule
    public Trashman trashman = new Trashman(api);

    static Long campaignId;

    @BeforeClass
    public static void initTest() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long pid = api.userSteps.adGroupsSteps().addGroup(new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId));
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(client);
        adGroup = jooqDbSteps.adGroupsSteps().getPhrases(pid);
    }

    @Test
    public void testStatusBsSynced() {
        assertThat("у созданной группы правильный статус синхронизации с БК",
                adGroup.getStatusbssynced(), equalTo(PhrasesStatusbssynced.No));
    }

    @Test
    public void testStatusModerate() {
        assertThat("у созданной группы правильный статус модерации",
                adGroup.getStatusmoderate(), equalTo(PhrasesStatusmoderate.New));
    }

    @Test
    public void testStatusPostModerate() {
        assertThat("у созданной группы правильный статус пост-модерации",
                adGroup.getStatuspostmoderate(), equalTo(PhrasesStatuspostmoderate.No));
    }
}
