package ru.yandex.autotests.direct.api.adgroups.add;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by buhter on 20.11.15.
 * https://st.yandex-team.ru/TESTIRT-7178
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Description("Проверка типов созданных групп")
@Issue("https://st.yandex-team.ru/DIRECT-44780")
public class AddAdGroupsTypeTest {

    private static final String client = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    static Long campaignId;
    private static DirectJooqDbSteps jooqDbSteps;

    @BeforeClass
    public static void initTest() {
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    public void testAddMobileGroupType() {
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.MOBILE_CONTENT);
        Long pid = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        PhrasesRecord phrasesRecord = jooqDbSteps.adGroupsSteps().getPhrases(pid);
        assertThat("группа создалась с правильным типом", phrasesRecord.getAdgroupType()
                , equalTo(PhrasesAdgroupType.mobile_content));
    }

    @Test
    public void testAddTextGroupType() {
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.TEXT);
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        PhrasesRecord phrasesRecord = jooqDbSteps.adGroupsSteps().getPhrases(pid);
        assertThat("группа создалась с правильным типом", phrasesRecord.getAdgroupType()
                , equalTo(PhrasesAdgroupType.base));
    }

    @Test
    public void testAddCpmVideoGroupType() {
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);
        Long pid = api.userSteps.adGroupsSteps().addDefaultCpmVideoGroup(campaignId);
        PhrasesRecord phrasesRecord = jooqDbSteps.adGroupsSteps().getPhrases(pid);
        assertThat("группа создалась с правильным типом", phrasesRecord.getAdgroupType()
                , equalTo(PhrasesAdgroupType.cpm_video));
    }
}
