package ru.yandex.autotests.direct.api.adgroups.add;

import com.yandex.direct.api.v5.adgroups.AddResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.CoreMatchers.notNullValue;
import static org.hamcrest.Matchers.contains;
import static org.hamcrest.Matchers.either;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Author pavryabov
 * Date 24.08.14
 * https://st.yandex-team.ru/TESTIRT-2022
 */
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Features(AdGroupsFeatures.ADD)
public class AddCampaignIdTest {

    private static final String CLIENT = AdGroupsLogins.CLIENT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long draftCampaignId;
    private static Long moderatedCampaignId;
    private static Long activeCampaignId;
    private static long notExistedCampaignId;
    private static Long deletedCampaignId;
    private static Long archivedCampaignId;
    private static AdGroupAddItemMap adGroupAddItemMap;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        draftCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        moderatedCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        api.userSteps.campaignFakeSteps().makeCampaignModerated(moderatedCampaignId);
        activeCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        api.userSteps.campaignFakeSteps().makeCampaignActive(activeCampaignId);
        notExistedCampaignId = activeCampaignId + 100000;
        deletedCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        api.userSteps.campaignSteps().campaignsDelete(deletedCampaignId);
        archivedCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        api.userSteps.campaignSteps().campaignsSuspend(archivedCampaignId);
        api.userSteps.campaignSteps().campaignsArchive(archivedCampaignId);
        adGroupAddItemMap = new AdGroupAddItemMap()
                .withName(AdGroupAddItemMap.DEFAULT_NAME)
                .withRegionIds(0L);
    }

    @Before
    public void clearSpentUnits(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
    }

    @Test
    public void addWith0CampaignId() {
        // TODO DIRECT-75345 perlError будет не нужен, надо вернуть обратно shouldGetResultOnAdd

        AddResponse response = api.userSteps.adGroupsSteps().defaultClientV5().invokeMethod(
                ServiceNames.AD_GROUPS, null, Action.ADD,
                new AddRequestMap().withAdGroups(adGroupAddItemMap.withCampaignId(0L)).getBean());

        Notification perlError = new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER,
                capitalize(AdGroupAddItemMap.CAMPAIGN_ID));

        Notification javaError = new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                capitalize(AdGroupAddItemMap.CAMPAIGN_ID));

        assertThat("содержание результатов соответствует ожидаемому", response.getAddResults(),
                contains(either(ExpectedResult.errors(perlError).getActionResultMatcher())
                        .or(ExpectedResult.errors(javaError).getActionResultMatcher())));
    }

    @Test
    public void addWithNegativeCampaignId() {
        // TODO DIRECT-75345 perlError будет не нужен, надо вернуть обратно shouldGetResultOnAdd

        AddResponse response = api.userSteps.adGroupsSteps().defaultClientV5().invokeMethod(
                ServiceNames.AD_GROUPS, null, Action.ADD,
                new AddRequestMap().withAdGroups(adGroupAddItemMap.withCampaignId(-draftCampaignId)).getBean());

        Notification perlError = new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER,
                capitalize(AdGroupAddItemMap.CAMPAIGN_ID));

        Notification javaError = new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                capitalize(AdGroupAddItemMap.CAMPAIGN_ID));

        assertThat("содержание результатов соответствует ожидаемому", response.getAddResults(),
                contains(either(ExpectedResult.errors(perlError).getActionResultMatcher())
                        .or(ExpectedResult.errors(javaError).getActionResultMatcher())));
    }

    @Test
    public void addWithDraftCampaignId() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        adGroupAddItemMap.withCampaignId(draftCampaignId)
                ),
                ExpectedResult.success()
        );
    }

    @Test
    public void addWithModeratedCampaignId() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        adGroupAddItemMap.withCampaignId(moderatedCampaignId)
                ),
                ExpectedResult.success()
        );
    }

    @Test
    public void addWithActiveCampaignId() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        adGroupAddItemMap.withCampaignId(activeCampaignId)
                ),
                ExpectedResult.success()
        );
    }

    @Test
    public void addWithNotExistedCampaignId() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        adGroupAddItemMap.withCampaignId(notExistedCampaignId)
                ),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND))
        );
    }

    @Test
    public void addWithDeletedCampaignId() {
        //DIRECT-33510
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        adGroupAddItemMap.withCampaignId(deletedCampaignId)
                ),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND))
        );
    }

    @Test
    public void addWithArchivedCampaignId() {
        //DIRECT-33511

        // TODO DIRECT-75345 perlError будет не нужен, надо вернуть обратно shouldGetResultOnAdd

        AddRequestMap request = new AddRequestMap()
                .withAdGroups(adGroupAddItemMap.withCampaignId(archivedCampaignId));

        AddResponse response = api.userSteps.adGroupsSteps().defaultClientV5()
                .invokeMethod(ServiceNames.AD_GROUPS, null, Action.ADD, request.getBean());

        assumeThat("получен ответ сервиса", response, notNullValue());

        Notification perlError = new Notification(8300, Api5ErrorDetails.UNABLE_UPDATE_ARCHIVED_CAMPAGN,
                capitalize(AdGroupAddItemMap.CAMPAIGN_ID));

        Notification javaError = new Notification(8300, Api5ErrorDetailsJava.UNABLE_TO_UPDATE_ARCHIVED_CAMPAIGN,
                capitalize(AdGroupAddItemMap.CAMPAIGN_ID));

        assertThat("содержание результатов соответствует ожидаемому", response.getAddResults(),
                contains(either(ExpectedResult.errors(perlError).getActionResultMatcher())
                        .or(ExpectedResult.errors(javaError).getActionResultMatcher())));
    }
}
