package ru.yandex.autotests.direct.api.adgroups.add;

import com.yandex.direct.api.v5.adgroups.AddResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 14.10.15.
 * https://st.yandex-team.ru/TESTIRT-7178
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Stories(AdGroupsStories.MOBILE)
@Description("Использование в запросе AdGroups.add разных типов групп")
@Issue("https://st.yandex-team.ru/DIRECT-44780")
public class AddDifferentTypesOfAdGroupsInOneRequestTest {

    private static final String client = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);
    private static DirectJooqDbSteps jooqDbSteps;


    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    static Long campaignIdText;
    static Long campaignIdMobileApp;

    @BeforeClass
    public static void initTest() {
        campaignIdText = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        campaignIdMobileApp = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        api.userSteps.campaignFakeSteps().setType(campaignIdMobileApp, CampaignsType.MOBILE_CONTENT);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(client);

    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    public void addTextAndMobileAppAdGroups() {
        AddResponse addResponse = api.userSteps.adGroupsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAdGroups(
                                new AdGroupAddItemMap().defaultAdGroupAddItem(campaignIdText),
                                new AdGroupAddItemMap().defaultAdGroupAddItem(campaignIdMobileApp)
                                        .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup())
                        ),
                ExpectedResult.success(), ExpectedResult.success());
        Long textId = addResponse.getAddResults().get(0).getId();
        Long mobileAppId = addResponse.getAddResults().get(1).getId();
        PhrasesRecord adGroup = jooqDbSteps.adGroupsSteps().getPhrases(textId);

        assertThat("текстовая группа создалась с правильным типом", adGroup.getAdgroupType(),
                equalTo(PhrasesAdgroupType.base));

        PhrasesRecord mobileAdGroup = jooqDbSteps.adGroupsSteps().getPhrases(mobileAppId);
        assertThat("группа РМП создалась с правильным типом", mobileAdGroup.getAdgroupType(),
                equalTo(PhrasesAdgroupType.mobile_content));
    }

    @Test
    public void addMobileAppAndTextCampaigns() {
        AddResponse addResponse = api.userSteps.adGroupsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAdGroups(
                                new AdGroupAddItemMap().defaultAdGroupAddItem(campaignIdMobileApp)
                                        .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup()),
                                new AdGroupAddItemMap().defaultAdGroupAddItem(campaignIdText)
                        ),
                ExpectedResult.success(), ExpectedResult.success());
        Long textId = addResponse.getAddResults().get(1).getId();
        Long mobileAppId = addResponse.getAddResults().get(0).getId();
        PhrasesRecord mobileAdGroup = jooqDbSteps.adGroupsSteps().getPhrases(mobileAppId);
        assertThat("группа РМП создалась с правильным типом", mobileAdGroup.getAdgroupType(),
                equalTo(PhrasesAdgroupType.mobile_content));
        PhrasesRecord adGroup = jooqDbSteps.adGroupsSteps().getPhrases(textId);
        assertThat("текстовая группа создалась с правильным типом", adGroup.getAdgroupType(),
                equalTo(PhrasesAdgroupType.base));
    }

    @Test
    public void addValidTextAndInvalidMobileAppAdGroups() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignIdText),
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignIdMobileApp + 100000)
                                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup())
                ),
                ExpectedResult.success(),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND))
        );
    }

    @Test
    public void addValidMobileAppAndInvalidTextAdGroups() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignIdMobileApp)
                                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup()),
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignIdText + 100000)
                ),
                ExpectedResult.success(),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND))
        );
    }

    @Test
    public void addInvalidTextAndInvalidMobileAppAdGroups() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignIdText + 100000),
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignIdMobileApp + 100000)
                                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup())
                ),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND))
        );
    }
}
