package ru.yandex.autotests.direct.api.adgroups.add;

import java.util.Arrays;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ArrayOfStringMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Author pavryabov
 * Date 21.10.14
 * https://st.yandex-team.ru/TESTIRT-2022
 */
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Features(AdGroupsFeatures.ADD)
public class AddInvalidParamsTest {
    private static final String CLIENT = AdGroupsLogins.CLIENT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();
    static Long campaignId;
    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
    }

    @Test
    public void addWithoutName() {
        //DIRECT-33530
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap()
                                .withCampaignId(campaignId)
                                .withRegionIds(0L)
                ),
                new Api5Error(8000, Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        capitalize(AddRequestMap.AD_GROUPS),
                        capitalize(AdGroupAddItemMap.NAME)));
    }

    @Test
    public void addWithoutRegionIds() {
        //DIRECT-33530
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap()
                                .withCampaignId(campaignId)
                                .withName(AdGroupAddItemMap.DEFAULT_NAME)
                ),
                new Api5Error(8000, Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        capitalize(AddRequestMap.AD_GROUPS),
                        capitalize(AdGroupAddItemMap.REGION_IDS)));
    }

    @Test
    public void addWithEmptyArrayOfNegativeKeywords() {
        //DIRECT-33530
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                                .withNegativeKeywords(new String[]{})
                ),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        path(AddRequestMap.AD_GROUPS, AdGroupAddItemMap.NEGATIVE_KEYWORDS,
                                ArrayOfStringMap.ITEMS), 1L));
    }

    @Test
    public void addWithEmptyRequest() {
        //DIRECT-33530
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsAdd(
                new AddRequestMap().withAdGroups((AdGroupAddItemMap[]) null),
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        path(AddRequestMap.AD_GROUPS), 1L));
    }

    @Test
    public void add1001Groups() {
        //DIRECT-33550
        AdGroupAddItemMap[] adGroupAddItemMaps = new AdGroupAddItemMap[AdGroupAddItemMap.GROUPS_MAX_LENGTH + 1];
        Arrays.fill(adGroupAddItemMaps, new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId));
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsAdd(
                new AddRequestMap().withAdGroups(adGroupAddItemMaps),
                new Api5Error(9300,
                        Api5ErrorDetails.ADD_NO_MORE_THAN, AdGroupAddItemMap.GROUPS_MAX_LENGTH)
        );
    }
}
