package ru.yandex.autotests.direct.api.adgroups.add;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Author pavryabov
 * Date 15.08.14
 * https://st.yandex-team.ru/TESTIRT-2022
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddNameTest {

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public String name;

    @Parameterized.Parameter(1)
    public Object expectedResult;

    @Parameterized.Parameters(name = "Name = {0}")
    public static Collection testData() throws UnsupportedEncodingException {
        Object[][] data = new Object[][]{
                {AdGroupAddItemMap.DEFAULT_NAME, ExpectedResult.success()},
                {"Русское имя с пробелом", ExpectedResult.success()},
                {" English name with space", ExpectedResult.success()},
                {new String("Имя".getBytes("UTF-8"), "Cp1251"), ExpectedResult.success()},
                {"123", ExpectedResult.success()},
                {" ", ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetails.GROUP_NAME_CANNOT_BE_EMPTY_STRING))},
                {"name\n", ExpectedResult.success()},
                {"name\\n", ExpectedResult.success()},
                {"name\"", ExpectedResult.success()},
                {"</Name>", ExpectedResult.success()},
                {"", ExpectedResult.errors(new Notification(5004, Api5ErrorDetails.GROUP_NAME_CANNOT_BE_EMPTY_STRING))},
                {RandomStringUtils.randomAlphabetic(AdGroupAddItemMap.MAX_NAME_LENGTH), ExpectedResult.success()},
                {RandomStringUtils.randomAlphabetic(AdGroupAddItemMap.MAX_NAME_LENGTH + 1),
                        ExpectedResult.errors(new Notification(5001,
                                Api5ErrorDetailsJava.FIELD_MAXIMUM_LENGTH_EXCEEDED,
                                capitalize(AdGroupAddItemMap.NAME),
                                AdGroupAddItemMap.MAX_NAME_LENGTH))}
        };
        return Arrays.asList(data);
    }

    private static AdGroupAddItemMap adGroupAddItemMap;

    @BeforeClass
    public static void createCampaign() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdGroupsLogins.CLIENT);
        adGroupAddItemMap = new AdGroupAddItemMap()
                .withCampaignId(campaignId)
                .withRegionIds(0L);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
    }

    @Test
    public void addGroupWithName() {
        //DIRECT-34280
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        adGroupAddItemMap.withName(name)),
                (ExpectedResult) expectedResult);
    }
}
