package ru.yandex.autotests.direct.api.adgroups.add;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MinusWordsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.cases.MinusWordsStorageCases;
import ru.yandex.autotests.directapi.converters.MinusWordsSerializer;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.junit.Assert.assertThat;

/**
 * Created by andy-ilyin on 12.09.16.
 * https://st.yandex-team.ru/TESTIRT-10213
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@Issue("https://st.yandex-team.ru/DIRECT-55547")
@Description("Проверка работы метода с новым JSON форматом минус-слов")
@RunWith(Parameterized.class)
public class AddNegativeKeywordsStorageTest {
    private static Long campaignId;
    private static DirectJooqDbSteps dbSteps;
    private static final MinusWordsSerializer minusWordSerializer = MinusWordsSerializer.CURRENT_SERIALIZER;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public String description;

    @Parameterized.Parameter(1)
    public String[] negativeKeywords;

    @Parameterized.Parameter(2)
    public String[] normalizedNegativeKeywords;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> testData() {
        List<Object[]> result = new LinkedList<>();
        for (MinusWordsStorageCases.TestCase testCase : MinusWordsStorageCases.getTestCases()) {
            result.add(new Object[] {
                    testCase.getDescription(),
                    testCase.getMinusWords().toArray(),
                    testCase.getNormalizedMinusWords().toArray()
            });
        }
        return result;
    }

    @BeforeClass
    public static void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(AdGroupsLogins.CLIENT);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
    }

    @Test
    public void testNegativeKeywordStorage() {
        Long adGroupId = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap()
                        .defaultAdGroupAddItem(campaignId)
                        .withNegativeKeywords(negativeKeywords)
        );

        PhrasesRecord phrasesRecord = dbSteps.adGroupsSteps().getPhrases(adGroupId);
        MinusWordsRecord minusWordsRecord = dbSteps.minusWordsSteps().getMinusWords(phrasesRecord.getMwId());

        assertThat("получены ожидаемые минус-слова",
                minusWordSerializer.read(minusWordsRecord.getMwText()),
                containsInAnyOrder(normalizedNegativeKeywords));
    }
}
