package ru.yandex.autotests.direct.api.adgroups.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.utils.model.RegionIDValues;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author pavryabov
 * Date 15.08.14
 * https://st.yandex-team.ru/TESTIRT-2022
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@RunWith(Parameterized.class)
public class AddRegionIdsPositiveTest {

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final Long MOSCOW = RegionIDValues.MOSCOW.getId().longValue();
    private static final Long CHERNOGOLOVKA = RegionIDValues.CHERNOGOLOVKA.getId().longValue();
    private static final Long MOSCOW_REGION = RegionIDValues.MOSCOW_AND_MOSCOW_REGION.getId().longValue();
    private static final Long RUSSIA = RegionIDValues.RUSSIA_COUNTRY.getId().longValue();
    private static final Long CRIMEA = RegionIDValues.CRIMEA.getId().longValue();
    private static final Long UKRAINE = RegionIDValues.UKRAINE.getId().longValue();
    private static final Long SEVASTOPOL = RegionIDValues.SEVASTOPOL.getId().longValue();

    @SuppressWarnings("DefaultAnnotationParam")
    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Long[] regionIds;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {

        Object[][] data = new Object[][]{
                {"All regions", new Long[]{0L}},
                {"One region", new Long[]{MOSCOW}},
                {"Two different regions", new Long[]{MOSCOW, CHERNOGOLOVKA}},
                {"Child with parent", new Long[]{MOSCOW, MOSCOW_REGION}},
                {"Region with zero", new Long[]{MOSCOW, 0L}},
                {"Exclude child from parent", new Long[]{MOSCOW_REGION, -MOSCOW}},
                {"Exclude child and child of child", new Long[]{-MOSCOW, -MOSCOW_REGION, RUSSIA}},
                {"Zero with negative", new Long[]{0L, MOSCOW_REGION, -MOSCOW}},
                {"Crimea", new Long[]{CRIMEA}},
                {"Exclude from Crimea", new Long[]{CRIMEA, -SEVASTOPOL}},
                {"Crimea and Ukraine", new Long[]{CRIMEA, UKRAINE}},
                {"Crimea and Russia", new Long[]{CRIMEA, RUSSIA}},
        };
        return Arrays.asList(data);
    }

    private static AdGroupAddItemMap adGroupAddItemMap;

    @BeforeClass
    public static void createCampaign() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdGroupsLogins.CLIENT);
        adGroupAddItemMap = new AdGroupAddItemMap()
                .withCampaignId(campaignId)
                .withName(AdGroupAddItemMap.DEFAULT_NAME);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
    }

    @Test
    public void addGroupWithRegionIds() {
        //DIRECT-34451, DIRECT-34452, DIRECT-34453, DIRECT-35721, DIRECT-35929
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        adGroupAddItemMap.withRegionIds(regionIds)
                ),
                ExpectedResult.success()
        );
    }
}
