package ru.yandex.autotests.direct.api.adgroups.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author pavryabov
 * Date 12.09.14
 * https://st.yandex-team.ru/TESTIRT-2022
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Stories(AdGroupsStories.SHARDING)
@RunWith(Parameterized.class)
public class AddShardingTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String agency = AdGroupsLogins.AGENCY;
    private static final String subclientShard2 = AdGroupsLogins.SUBCLIENT_SHARD2;
    private static final String agencyShard2 = AdGroupsLogins.AGENCY_SHARD2;
    private static final String subclientShard1 = AdGroupsLogins.AGENCY_SHARD2_SUB_SH1;
    private static final String manager = Logins.MANAGER_DEFAULT;
    private static final String servClientShard2 = AdGroupsLogins.SERV_CLIENT_SHARD2;

    static Long campaignId;

    @Parameterized.Parameter(0)
    public String operator;

    @Parameterized.Parameter(1)
    public String client;

    @Parameterized.Parameters(name = "operator = {0}, client = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {agency, subclientShard2},
                {agencyShard2, subclientShard1},
                {manager, servClientShard2},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void reshardUsers() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agencyShard2);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(manager);
        api.userSteps.clientFakeSteps().reshardUserWithLock(agency, ShardNumbers.DEFAULT_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(agencyShard2, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclientShard1, ShardNumbers.DEFAULT_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclientShard2, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(servClientShard2, ShardNumbers.EXTRA_SHARD);
    }

    @Test
    public void callAdd() {
        campaignId = api.as(operator).userSteps.campaignSteps().addDefaultTextCampaign(client);
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                ),
                client,
                ExpectedResult.success()
        );
    }
}
