package ru.yandex.autotests.direct.api.adgroups.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author pavryabov
 * Date 05.09.14
 * https://st.yandex-team.ru/TESTIRT-2022
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Stories(AdGroupsStories.AUTHORIZATION)
@RunWith(Parameterized.class)
public class AgencyAuthorizationNegativeTest {

    @ClassRule
    public static final ApiSteps api = new ApiSteps();

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String client = AdGroupsLogins.CLIENT;
    private static final String agency = AdGroupsLogins.AGENCY;
    private static final String agencyRep = AdGroupsLogins.AGENCY_REP;
    private static final String agencyRepCl = AdGroupsLogins.AGENCY_REP_CL;
    private static final String subclient = AdGroupsLogins.SUBCLIENT;
    private static final String subclientElse = AdGroupsLogins.SUBCLIENT_SHARD2;
    private static final String subclientNotMine = AdGroupsLogins.AGENCY_SHARD2_SUB_SH1;
    static Long campaignId;

    @Parameterized.Parameter(0)
    public String loginForAuthorization;

    @Parameterized.Parameter(1)
    public String loginForHeader;

    @Parameterized.Parameter(2)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}, loginForHeader = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {agency, null, new Api5Error(8000,
                        Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {agency, subclientNotMine, new Api5Error(8800,
                        Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN)},
                {agency, client, new Api5Error(8800,
                        Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN)},
                {agencyRep, null, new Api5Error(8000,
                        Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {agencyRepCl, null, new Api5Error(8000,
                        Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {agencyRepCl, subclientElse, new Api5Error(54)},
                {agency, agency, new Api5Error(8000,
                        Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {agency, agencyRep, new Api5Error(8000,
                        Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {agency, agencyRepCl, new Api5Error(8000,
                        Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {agencyRep, agency, new Api5Error(8000,
                        Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {agencyRep, agencyRep, new Api5Error(8000,
                        Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclientElse, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclientNotMine, ShardNumbers.DEFAULT_SHARD);
        campaignId = api.as(agency).userSteps.campaignSteps().addDefaultTextCampaign(subclient);
    }

    @Test
    public void callAddWithLoginInHeader() {
        api.as(loginForAuthorization).userSteps.adGroupsSteps().expectErrorOnAdGroupsAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                ),
                loginForHeader,
                expectedError
        );
    }
}
