package ru.yandex.autotests.direct.api.adgroups.add;

import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.common.RegionIDValues;
import ru.yandex.autotests.directapi.model.common.RemovedRegionIDValues;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by onotole on 9/29/16.
 * https://st.yandex-team.ru/DIRECT-56940
 */
@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Description("проверяем, что нельзя создать группу объявлений с удаленным регионом в геотаргетинге")
@RunWith(Parameterized.class)
@Tag(TagDictionary.NEVER_RUN)
public class CheckRemoveRegionsTest {
    private static final String client = Logins.CLIENT_FOR_RUB;
    private static Long campaignId;

    @Parameterized.Parameter(0)
    public Long geoRegionId;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> testData() {
        return RemovedRegionIDValues.values;
    }

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void setUp() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    public void createAdGroupWithRemovedRegion() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                            .withRegionIds(geoRegionId)
                ),
                ExpectedResult.errors(new Notification(5120,
                        Api5ErrorDetails.INVALID_OR_NONEXISTENT_REGION, geoRegionId))
        );
    }

    @Test
    public void createAdGroupWithMinusRemovedRegion() {
        Long minusRegionId = -geoRegionId;
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                                .withRegionIds(Long.valueOf(RegionIDValues.UKRAINIAN_REGION_ID), minusRegionId)
                ),
                ExpectedResult.errors(new Notification(5120,
                        Api5ErrorDetails.INVALID_OR_NONEXISTENT_REGION, minusRegionId))
        );
    }
}
