package ru.yandex.autotests.direct.api.adgroups.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author pavryabov
 * Date 08.10.14
 * https://st.yandex-team.ru/TESTIRT-2022
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Stories(AdGroupsStories.AUTHORIZATION)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class CheckWriteRightsToClientWithDifferentOwnersTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String oldAgency = Logins.AGENCY_YE_DEFAULT;
    private static final String agencyElse = AdGroupsLogins.AGENCY_SHARD2;
    private static final String manager = Logins.MANAGER_DEFAULT;
    private static final String subclientWithServiceCampaigns = Logins.CLIENT_FREE_YE_DEFAULT;
    Long campaignId;
    Long id;

    @Parameterized.Parameter(0)
    public String agency;

    @Parameterized.Parameter(1)
    public String subclient;

    @Parameterized.Parameter(2)
    public String secondOwner;

    @Parameterized.Parameter(3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "agency = {0}, subclient = {1}, secondOwner = {2}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {oldAgency, subclientWithServiceCampaigns, manager,
                        ExpectedResult.success()}, //DIRECT-64601
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void reshardUsers() {
        api.userSteps.clientFakeSteps().reshardUserWithLock(agencyElse, ShardNumbers.EXTRA_SHARD);
    }

    @Before
    public void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(secondOwner);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
        campaignId = api.as(secondOwner).userSteps.campaignSteps().addDefaultTextCampaign(subclient);
        id = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, subclient);
    }

    @Test
    public void checkRightsToWrite() {
        api.as(agency).userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                ),
                subclient,
                expectedResult
        );
    }
}
