package ru.yandex.autotests.direct.api.adgroups.add;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

/**
 * Author pavryabov
 * Date 05.09.14
 * https://st.yandex-team.ru/TESTIRT-2022
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Stories(AdGroupsStories.AUTHORIZATION)
@RunWith(Parameterized.class)
public class ClientAuthorizationNegativeTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String client = AdGroupsLogins.CLIENT;
    private static final String clientRep = AdGroupsLogins.CLIENT_REP;
    private static final String otherClient = AdGroupsLogins.CLIENT_SHARD2;
    private static final String clientNoAccessToAPI = AdGroupsLogins.SUBCLIENT_ELSE;
    private static final String clientNoDirect = AdGroupsLogins.CLIENT_NO_DIRECT;

    @Parameterized.Parameter(0)
    public String loginForAuthorization;

    @Parameterized.Parameter(1)
    public String loginForHeader;

    @Parameterized.Parameter(2)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}, loginForHeader = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {client, otherClient,
                        new Api5Error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN)},
                {clientRep, otherClient,
                        new Api5Error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN)},
                {//DIRECT-43260
                        clientNoAccessToAPI, null,
                        new Api5Error(3000, Api5ErrorDetails.ACCOUNT_BLOCKED)},
                {client, clientNoDirect,
                        new Api5Error(53, Api5ErrorDetails.EMPTY_STRING)},
                {clientNoDirect, null,
                        new Api5Error(513, Api5ErrorDetails.EMPTY_STRING)},
                {clientNoDirect, clientNoDirect,
                        new Api5Error(513, Api5ErrorDetails.EMPTY_STRING)},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void reshardUsers() {
        api.userSteps.clientFakeSteps().disableAPI(clientNoAccessToAPI);
        api.userSteps.clientFakeSteps().reshardUserWithLock(otherClient, ShardNumbers.EXTRA_SHARD);
    }

    @Test
    public void callAddWithLoginInHeader() {
        //DIRECT-35003
        api.as(loginForAuthorization).userSteps.adGroupsSteps().expectErrorOnAdGroupsAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(123L)
                ),
                loginForHeader,
                expectedError
        );
    }
}
