package ru.yandex.autotests.direct.api.adgroups.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author pavryabov
 * Date 12.09.14
 * https://st.yandex-team.ru/TESTIRT-2022
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Stories(AdGroupsStories.AUTHORIZATION)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class InternalRolesAuthorizationNegativeTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String client = AdGroupsLogins.CLIENT;

    static Long campaignId;

    @Parameterized.Parameter(0)
    public String loginForAuthorization;

    @Parameterized.Parameter(1)
    public String loginForHeader;

    @Parameterized.Parameter(2)
    public String fakeLogin;

    @Parameterized.Parameter(3)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}, loginForHeader = {1}, fakeLogin = {2}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Logins.MANAGER_DEFAULT, null, null,
                        new Api5Error(8000, Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {Logins.MANAGER_DEFAULT, client, null,
                        new Api5Error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN)},
                {Logins.PLACER, null, null,
                        new Api5Error(8000, Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {Logins.SUPPORT, null, null,
                        new Api5Error(8000, Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {Logins.MEDIA, null, null,
                        new Api5Error(8000, Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {Logins.SUPER_READER, null, null,
                        new Api5Error(8000, Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {Logins.SUPER_LOGIN, null, null,
                        new Api5Error(8000, Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {Logins.MANAGER_DEFAULT, null, AdGroupsLogins.SERV_CLIENT,
                        new Api5Error(8000, Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {Logins.SUPER_LOGIN, null, AdGroupsLogins.AGENCY,
                        new Api5Error(8000, Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign() {
        campaignId = api.as(client).userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(loginForAuthorization);
    }

    @Test
    public void callAddWithLoginInHeader() {
        api.as(loginForAuthorization, fakeLogin).userSteps.adGroupsSteps().expectErrorOnAdGroupsAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                ),
                loginForHeader,
                expectedError
        );
    }
}
