package ru.yandex.autotests.direct.api.adgroups.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.utils.model.ApiAccessCredentials;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.model.AuthenticationData.APP_ACCEPTED_OFF;
import static ru.yandex.autotests.directapi.model.AuthenticationData.APP_ACCEPTED_TEST_REQUEST;
import static ru.yandex.autotests.directapi.model.AuthenticationData.APP_DECLINED_REQUEST;
import static ru.yandex.autotests.directapi.model.AuthenticationData.APP_DELETED_REQUEST;
import static ru.yandex.autotests.directapi.model.AuthenticationData.APP_NEW_FULL_REQUEST;
import static ru.yandex.autotests.directapi.model.AuthenticationData.APP_NEW_TEST_REQUEST;

/**
 * Created by pavryabov on 03.07.15.
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Stories(AdGroupsStories.AUTHORIZATION)
@Issue("https://st.yandex-team.ru/DIRECT-43248")
@RunWith(Parameterized.class)
public class InvalidRequestsTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String applicationDescription;

    @Parameterized.Parameter(1)
    public ApiAccessCredentials credentials;

    @Parameterized.Parameters(name = "Application = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"APP_NEW_FULL_REQUEST", APP_NEW_FULL_REQUEST},
                {"APP_NEW_TEST_REQUEST", APP_NEW_TEST_REQUEST},
                {"APP_ACCEPTED_TEST_REQUEST", APP_ACCEPTED_TEST_REQUEST},
                {"APP_DELETED_REQUEST", APP_DELETED_REQUEST},
                {"APP_DECLINED_REQUEST", APP_DECLINED_REQUEST},
                {"APP_ACCEPTED_OFF", APP_ACCEPTED_OFF},
        };
        return Arrays.asList(data);
    }

    @Test
    public void checkAccessToAPI() {
        api.as(credentials.getLogin()).applicationID(credentials.getApplicationId()).userSteps
                .adGroupsSteps().expectErrorOnAdGroupsAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(123L)
                ),
                new Api5Error(58, Api5ErrorDetailsJava.YOU_MUST_FILL_REQUEST_AND_WAIT_CONFIRMATION));
    }
}
