package ru.yandex.autotests.direct.api.adgroups.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author pavryabov
 * Date 04.09.14
 * https://st.yandex-team.ru/TESTIRT-2022
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Stories(AdGroupsStories.AUTHORIZATION)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class TokenTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String token;

    @Parameterized.Parameter(1)
    public Api5Error expectedError;

    /* полный набор вариантов токенов содержится в api/t/authorization.t */
    @Parameterized.Parameters(name = "token = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                { null, new Api5Error(8000, Api5ErrorDetails.ABSENT_OAUTH_TOKEN) },
                { "==", new Api5Error(8000, Api5ErrorDetails.INVALID_OAUTH_TOKEN_FORMAT) },
                { "", new Api5Error(8000, Api5ErrorDetails.ABSENT_OAUTH_TOKEN) },
                { "==invalidtoken",
                        new Api5Error(8000, Api5ErrorDetails.INVALID_OAUTH_TOKEN_FORMAT) },
                { "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaazz=== ",
                        new Api5Error(53, Api5ErrorDetailsJava.EXPIRED_OAUTH_TOKEN) },
                { "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaazz        ",
                        new Api5Error(53, Api5ErrorDetailsJava.EXPIRED_OAUTH_TOKEN) }
        };
        return Arrays.asList(data);
    }

    @Test
    public void addWithToken() {
        //DIRECT-34825
        api.token(token).protocol(ProtocolType.JSON).userSteps.adGroupsSteps().expectErrorOnAdGroupsAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(123L)
                ),
                expectedError
        );
    }

    @Test
    public void addWithTokenInvalidJSON() {
        api.token(token).protocol(ProtocolType.INVALID_JSON).userSteps.adGroupsSteps().expectErrorOnAdGroupsAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(123L)
                ),
                expectedError
        );
    }
}
