package ru.yandex.autotests.direct.api.adgroups.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 05.06.16.
 * https://st.yandex-team.ru/TESTIRT-9397
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Stories(AdGroupsStories.AUTHORIZATION)
@Issue("https://st.yandex-team.ru/DIRECT-54277")
@Description("Негативные сценарии использования заголовка Token-Type")
@RunWith(Parameterized.class)
public class TokenTypeNegativeTest {

    private static final String CLIENT = Logins.CLIENT_WITH_PERSISTENT_TOKEN;
    private static final String PERSISTENT_TOKEN = "4ef4249b027254ed7598cb7562f8a8e8e2a6e96d4a488bbda314643ee8259d3f";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String tokenType;

    @Parameterized.Parameter(1)
    public Boolean usePersistentToken;

    @Parameterized.Parameters(name = "tokenType = {0}, use persistent token = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"persistent", false},
                {"someValue", true},
                {null, true}
        };
        return Arrays.asList(data);
    }

    @Test
    public void addAdGroup() {
        if (usePersistentToken) {
            api.token(PERSISTENT_TOKEN);
        }
        api.tokenType(tokenType).userSteps.adGroupsSteps().expectErrorOnAdGroupsAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(123L)
                ),
                new Api5Error(53, Api5ErrorDetailsJava.EXPIRED_OAUTH_TOKEN)
        );
    }
}
