package ru.yandex.autotests.direct.api.adgroups.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.utils.model.MongoUser;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 05.06.16.
 * https://st.yandex-team.ru/TESTIRT-9397
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Stories(AdGroupsStories.AUTHORIZATION)
@Issue("https://st.yandex-team.ru/DIRECT-54277")
@Description("Позитивные сценарии использования заголовка Token-Type")
@RunWith(Parameterized.class)
public class TokenTypePositiveTest {

    private static final String CLIENT = Logins.CLIENT_WITH_PERSISTENT_TOKEN;

    private static Long camapignId;


    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @SuppressWarnings("DefaultAnnotationParam")
    @Parameterized.Parameter(0)
    public String tokenType;

    @Parameterized.Parameter(1)
    public Boolean usePersistentToken;

    @Parameterized.Parameters(name = "tokenType = {0}, use persistent token = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                // NB: на ТС этот сценарий работает только в акве. При запуске
                // с ноутбука падает, потому что ноутбуков нет в ACL, действительном на ТС
                // но на бетах в этом ACL все внутренние сети, так что на бетах работает
                {"persistent", true},

                {"someValue", false},
                {null, false}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign() {
        camapignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    public void addAdGroup() {
        if (usePersistentToken) {
            MongoUser mongoUser = MongoUser.get(CLIENT);
            // Там лежит persistent token
            api.token(mongoUser.getSandboxToken());
        }
        api.tokenType(tokenType).userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(camapignId)
                ),
                ExpectedResult.success()
        );
    }
}
