package ru.yandex.autotests.direct.api.adgroups.add;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import javax.xml.ws.handler.MessageContext;

import com.sun.xml.ws.developer.WSBindingProvider;
import com.yandex.direct.api.v5.adgroups.AdGroupsPort;
import com.yandex.direct.api.v5.adgroups.AddRequest;
import com.yandex.direct.api.v5.adgroups.ApiException;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMatcher;
import ru.yandex.autotests.directapi.apiclient.version5.SOAPClientV5;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by onotole on 8/5/16.
 * https://st.yandex-team.ru/TESTIRT-9945
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Stories(ApiStories.UNITS)
@Issue("https://st.yandex-team.ru/DIRECT-53941")
@Description("при списании баллов за ошибочный запрос оператора в ответе возвращается заголовок с логином оператора")
public class UnitsUsedLoginInHeadersErrorRequestTest {
    private static final String AGENCY = AdGroupsLogins.AGENCY;
    private static final String SUBCLIENT = AdGroupsLogins.SUBCLIENT;
    static Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AGENCY);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        campaignId = api.as(AGENCY).userSteps.campaignSteps().addDefaultTextCampaign(SUBCLIENT);
    }

    @Test
    public void checkUnitsUsedLoginAgencyInHeadersForBadRequest() {
        SOAPClientV5 soapClientV5 = api.as(AGENCY).userSteps.soapClientV5();
        AdGroupsPort adGroupsPort = soapClientV5.adGroupsService(SUBCLIENT);
        try {
            adGroupsPort.add((AddRequest) new AddRequestMap().withAdGroups(
                    new AdGroupAddItemMap()
                            .withCampaignId(campaignId)
                            .withName(AdGroupAddItemMap.DEFAULT_NAME)
            ).getBean());
        } catch (ApiException apiException) {
            Api5Error api5Error;
            if (!soapClientV5.isLastJavaResponse()) {
                api5Error = new Api5Error(
                        8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(AddRequestMap.AD_GROUPS),
                        capitalize(AdGroupAddItemMap.REGION_IDS));

            }
            else {
                api5Error = new Api5Error(
                        8000, Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        capitalize(AddRequestMap.AD_GROUPS),
                        capitalize(AdGroupAddItemMap.REGION_IDS));
            }

            assertThat("совпал текст ошибки (SOAP)",
                    new Api5Error(new ru.yandex.autotests.direct.utils.model.ApiException(apiException)),
                    Api5ErrorMatcher.equalToIgnoreLocale(api5Error));
        }
        WSBindingProvider bp = (WSBindingProvider) adGroupsPort;
        Map responseHeaders = (TreeMap) bp.getResponseContext().get(MessageContext.HTTP_RESPONSE_HEADERS);

        String unitsUsedLoginHeader = "Units-Used-Login";
        assumeThat("Header Units-Used-Login содержится в ответе", responseHeaders.containsKey(unitsUsedLoginHeader),
                equalTo(true));
        assertThat("Header Units-Used-Login содержит имя правильного юзера",
                ((List) responseHeaders.get(unitsUsedLoginHeader)).get(0).toString(), equalTo(AGENCY));
    }
}
