package ru.yandex.autotests.direct.api.adgroups.add.cpmbanneradgroup;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupsCpmBannerCriterionType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsCpmBannerRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Description("Проверка записи в БД")
@Issue("https://st.yandex-team.ru/DIRECT-83722")
public class CpmBannerAdGroupAddDBTest {

    private static final String CLIENT = AdGroupsLogins.CLIENT;
    private static final Long GEO = 225L;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static DirectJooqDbSteps dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);
    private Long campaignId;

    @Before
    @Step("Подготовка тестовых данных")
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);
    }

    @Test
    public void testKeywordsAdGroup() {
        Long pid = api.userSteps.adGroupsSteps().addGroup(new AdGroupAddItemMap()
                .defaultAdGroupAddItem(campaignId)
                .withRegionIds(GEO)
                .withCpmBannerKeywordsAdGroup());
        PhrasesRecord phrasesRecord = dbSteps.adGroupsSteps().getPhrases(pid);
        PhrasesRecord expected = new PhrasesRecord()
                .setPid(pid)
                .setAdgroupType(PhrasesAdgroupType.cpm_banner)
                .setGeo(GEO.toString());
        assertThat("группа правильно сохранилась в ppc.phrases", phrasesRecord.intoMap(),
                beanDiffer(expected.intoMap()).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
        AdgroupsCpmBannerRecord adgroupsCpmBannerRecord = dbSteps.adGroupsSteps().getAdgroupsCpmBanner(pid);
        AdgroupsCpmBannerRecord expectedAdgroupsCpmBanner = new AdgroupsCpmBannerRecord()
                .setPid(pid)
                .setCriterionType(AdgroupsCpmBannerCriterionType.keyword)
                .setHasInBannerCreatives(0);
        assertThat("группа правильно сохранилась в ppc.adgroups_cpm_banner", adgroupsCpmBannerRecord.intoMap(),
                beanDiffer(expectedAdgroupsCpmBanner.intoMap()));
    }

    @Test
    public void testUserProfileAdGroup() {
        Long pid = api.userSteps.adGroupsSteps().addGroup(new AdGroupAddItemMap()
                .defaultAdGroupAddItem(campaignId)
                .withRegionIds(GEO)
                .withCpmBannerUserProfileAdGroup());
        PhrasesRecord phrasesRecord = dbSteps.adGroupsSteps().getPhrases(pid);
        PhrasesRecord expected = new PhrasesRecord()
                .setPid(pid)
                .setAdgroupType(PhrasesAdgroupType.cpm_banner)
                .setGeo(GEO.toString());
        assertThat("группа правильно сохранилась в ppc.phrases", phrasesRecord.intoMap(),
                beanDiffer(expected.intoMap()).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
        AdgroupsCpmBannerRecord adgroupsCpmBannerRecord = dbSteps.adGroupsSteps().getAdgroupsCpmBanner(pid);
        AdgroupsCpmBannerRecord expectedAdgroupsCpmBanner = new AdgroupsCpmBannerRecord()
                .setPid(pid)
                .setCriterionType(AdgroupsCpmBannerCriterionType.user_profile)
                .setHasInBannerCreatives(0);
        assertThat("группа правильно сохранилась в ppc.adgroups_cpm_banner", adgroupsCpmBannerRecord.intoMap(),
                beanDiffer(expectedAdgroupsCpmBanner.intoMap()));
    }
}
