package ru.yandex.autotests.direct.api.adgroups.add.cpmbanneradgroup;

import com.yandex.direct.api.v5.adgroups.AddResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Description("Создание групп cpm_banner")
@Issue("https://st.yandex-team.ru/DIRECT-83722")
public class CpmBannerAdGroupAddTest {

    private static final String CLIENT = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private Long cpmBannerCampaignId;
    private Long cpmDealsCampaignIdElse;

    @Before
    public void initTest() {
        cpmBannerCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(cpmBannerCampaignId, CampaignsType.CPM_BANNER);
        cpmDealsCampaignIdElse = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(cpmDealsCampaignIdElse, CampaignsType.CPM_DEALS);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    public void addOneGroup() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(cpmBannerCampaignId)
                                .withCpmBannerUserProfileAdGroup()
                ),
                ExpectedResult.success()
        );
    }
    @Test
    public void addOneGroup_hasCpmGeoproduct_adGroupTypeNotSupported() {
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);

        AddResponse addResponse = api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(cpmBannerCampaignId)
                                .withCpmBannerUserProfileAdGroup()
                ),
                ExpectedResult.success()
        );
        Long pid = addResponse.getAddResults().get(0).getId();
        jooqDbSteps.adGroupsSteps().setType(pid, PhrasesAdgroupType.cpm_geoproduct);
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(cpmBannerCampaignId)
                                .withCpmBannerUserProfileAdGroup()
                ),
                ExpectedResult.errors(new Notification(3500, Api5ErrorDetails.ADGROUP_NOT_SUPPORTED))
        );
    }

    @Test
    public void addTwoGroupsInOneCampaign() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(cpmBannerCampaignId)
                                .withCpmBannerUserProfileAdGroup(),
                        new AdGroupAddItemMap().defaultAdGroupAddItem(cpmBannerCampaignId)
                                .withCpmBannerUserProfileAdGroup()
                ),
                ExpectedResult.success(), ExpectedResult.success()
        );
    }

    @Test
    public void addTwoGroupsInTwoCampaigns() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(cpmBannerCampaignId)
                                .withCpmBannerUserProfileAdGroup(),
                        new AdGroupAddItemMap().defaultAdGroupAddItem(cpmDealsCampaignIdElse)
                                .withCpmBannerUserProfileAdGroup()
                ),
                ExpectedResult.success(), ExpectedResult.success()
        );
    }

    @Test
    public void tryToSetNegativeKeywordsInUserProfileAdGroup() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap()
                                .defaultAdGroupAddItem(cpmBannerCampaignId)
                                .withNegativeKeywords("blalalala")
                                .withCpmBannerUserProfileAdGroup()
                ),
                ExpectedResult
                        .errors(new Notification(6000, Api5ErrorDetailsJava.MINUS_KEYWORDS_NOT_ALLOWED)));
    }

    @Test
    public void setNegativeKeywordsInKeywordsAdGroup() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap()
                                .defaultAdGroupAddItem(cpmBannerCampaignId)
                                .withNegativeKeywords("blalalala")
                                .withCpmBannerKeywordsAdGroup()
                ),
                ExpectedResult.success()
        );
    }
}
