package ru.yandex.autotests.direct.api.adgroups.add.dynamictextadgroup;

import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsDynamicRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.DomainsRecord;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.DynamicTextAdGroupMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsEqual.equalTo;
import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 25.11.15.
 * https://st.yandex-team.ru/TESTIRT-7819
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Stories(AdGroupsStories.DYNAMIC_TEXT)
@Description("Проверка записи в БД")
@Issue("https://st.yandex-team.ru/DIRECT-41334")
public class DynamicTextAdGroupAddDBTest {

    private static final String DOMAIN_URL = DynamicTextAdGroupMap.DEFAULT_DOMAIN_URL;
    private static final String client = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static DomainsRecord domains;

    @Rule
    public Trashman trashman = new Trashman(api);

    static Integer campaignId;
    static Integer shard;

    @Before
    @Step("Подготовка тестовых данных")
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        shard = api.userSteps.clientFakeSteps().getUserShard(client);
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign().intValue();
        Long pid = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId.longValue())
                        .withDynamicTextAdGroup(
                                new DynamicTextAdGroupMap().withDomainUrl(DOMAIN_URL)
                        )
        );
        AdgroupsDynamicRecord adgroupsDynamicRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().getAdgroupsDynamic(pid);
        assumeThat("получена непустая запись для AdgroupsDynamic", adgroupsDynamicRecord, notNullValue());
        domains = api.userSteps.getDirectJooqDbSteps().useShard(shard).domainsSteps()
                .getDomainsDictRecord(adgroupsDynamicRecord.getMainDomainId());
        assumeThat("получена непустая запись для Domains", domains, notNullValue());
    }

    @Test
    public void testAddGroupAndVerifyDBDomain() {
        assertThat("в базу записан правильный домен", domains.getDomain(), equalTo(DOMAIN_URL));
        assertThat("в базу записан правильный домен", domains.getReverseDomain()
                , equalTo(StringUtils.reverse(DOMAIN_URL)));
    }

}

