package ru.yandex.autotests.direct.api.adgroups.add.dynamictextadgroup;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.DynamicTextAdGroupMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by buhter on 25.11.15.
 * https://st.yandex-team.ru/TESTIRT-7819
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Stories(AdGroupsStories.DYNAMIC_TEXT)
@Issue("https://st.yandex-team.ru/DIRECT-41334")
@RunWith(Parameterized.class)
public class DynamicTextAdGroupAddDomainUrlTest {

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String domainUrl;

    @Parameterized.Parameter(1)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "Domain URL - \"{0}\"")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"hide.su", ExpectedResult.success()},
                {"rambler.ru", ExpectedResult.success()},
                {"direct.yandex.ru", ExpectedResult.success()},
                {"sdfergervgfgbhfg.ruf", ExpectedResult.success()},
                {"link.ac", ExpectedResult.success()},
                {"продвижение-статьями.рф", ExpectedResult.success()},
                {"xn----8sbehgafpcd7bhhnp0arb4q8b.xn--p1ai", ExpectedResult.success()},
                {"yandex.ru ", ExpectedResult.errors(new Notification(5004,
                        Api5ErrorDetails.INVALID_PRIMARY_DOMAIN_OF_AD_GROUP))},
                {" yandex.ru", ExpectedResult.errors(new Notification(5004,
                        Api5ErrorDetails.INVALID_PRIMARY_DOMAIN_OF_AD_GROUP))},
                {"yandex .ru", ExpectedResult.errors(new Notification(5004,
                        Api5ErrorDetails.INVALID_PRIMARY_DOMAIN_OF_AD_GROUP))},
                {"http://yandex.ru", ExpectedResult.errors(new Notification(5004,
                        Api5ErrorDetails.INVALID_PRIMARY_DOMAIN_OF_AD_GROUP))},
                {"yandex.ru/404", ExpectedResult.errors(new Notification(5004,
                        Api5ErrorDetails.INVALID_PRIMARY_DOMAIN_OF_AD_GROUP))},
                {" ", ExpectedResult.errors(new Notification(5004,
                        Api5ErrorDetails.INVALID_PRIMARY_DOMAIN_OF_AD_GROUP))},
                {"some_link", ExpectedResult.errors(new Notification(5004,
                        Api5ErrorDetails.INVALID_PRIMARY_DOMAIN_OF_AD_GROUP))},
                {"", ExpectedResult.errors(new Notification(5000,
                        Api5ErrorDetails.NEED_TO_SET_PRIMARY_DOMAIN_OF_AD_GROUP))}
        };
        return Arrays.asList(data);
    }

    private static Integer campaignId;

    @BeforeClass
    public static void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign().intValue();
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
    }

    @Test
    public void addGroupWithDomainUrl() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(new AdGroupAddItemMap()
                        .defaultAdGroupAddItem(campaignId.longValue())
                        .withDynamicTextAdGroup(new DynamicTextAdGroupMap()
                                .defaultGroup()
                                .withDomainUrl(domainUrl)
                        )
                ),
                expectedResult
        );
    }
}

