package ru.yandex.autotests.direct.api.adgroups.add.dynamictextadgroup;

import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.GroupFakeInfo;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 01.12.15.
 * https://st.yandex-team.ru/TESTIRT-7819
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Stories(AdGroupsStories.DYNAMIC_TEXT)
@Issue("https://st.yandex-team.ru/DIRECT-41334")
public class DynamicTextAdGroupAddLastChangeTest {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");

    private static final String client = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);
    private static Long pid;

    @Before
    public void before() {
        Integer campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign().intValue();
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
    }

    @Test
    public void testLastChange(){
        GroupFakeInfo groupInfo = api.userSteps.groupFakeSteps().getGroupParams(pid);
        assumeThat("время последнего изменения группы", groupInfo.getLastChange(), notNullValue());
        LocalDate date = DATE_TIME_FORMATTER.parseLocalDate(groupInfo.getLastChange());
        assertThat("время последнего изменения группы", date, equalTo(LocalDate.now()));
    }
}
