package ru.yandex.autotests.direct.api.adgroups.add.mobileappadgroup;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Stories(AdGroupsStories.MOBILE)
@Tag(TagDictionary.TRUNK)
@Description("Создание групп РМП с разными ссылками на одно приложение")
@Issue("https://st.yandex-team.ru/DIRECT-97539")
@RunWith(Parameterized.class)
public class AddMobileAdGroupsWithSlightlyDifferentUrlsTest {

    @Parameterized.Parameters(name = "{3}")
    public static Collection<Object[]> parameters() {
        Object[][] result = new Object[][]{
                new Object[]{
                        "https://itunes.apple.com/ru/app/angry-birds-classic/id343200656",
                        "https://apps.apple.com/ru/app/angry-birds-classic/id343200656",
                        "https://apps.apple.com/en/app/angry-birds-classic/id343200656",
                        "App store with changed domain"
                },
                new Object[]{
                        "https://play.google.com/store/apps/details?id=ru.aviasales",
                        "https://play.google.com/store/apps/details?id=ru.aviasales&hl=en&gl=ru",
                        "https://play.google.com/store/apps/details?id=ru.aviasales&gl=us",
                        "Play market with changed gl and hl params"
                },
        };

        return Arrays.asList(result);
    }

    @Parameterized.Parameter
    public String baseUrl;

    @Parameterized.Parameter(1)
    public String correctlyModifiedUrl;

    @Parameterized.Parameter(2)
    public String incorrectlyModifiedUrl;

    @Parameterized.Parameter(3)
    public String desciption;

    private static final String client = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private Long campaignId;

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign(client);
    }

    @Test
    public void addTwoGroupsInTwoRequests_FirstWithCorrectlyModifiedUrlSecondWithBase_Success() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId.longValue())
                                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup()
                                        .withStoreUrl(correctlyModifiedUrl))
                ), ExpectedResult.success()
        );

        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId.longValue())
                                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup()
                                        .withStoreUrl(baseUrl))
                ), ExpectedResult.success()
        );
    }

    @Test
    public void addTwoGroupsInTwoRequests_BothWithCorrectlyModifiedUrl_Success() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId.longValue())
                                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup()
                                        .withStoreUrl(correctlyModifiedUrl))
                ), ExpectedResult.success()
        );

        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId.longValue())
                                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup()
                                        .withStoreUrl(correctlyModifiedUrl))
                ), ExpectedResult.success()
        );
    }

    @Test
    public void addTwoGroupsInTwoRequests_FirstWithIncorrectlyModifiedUrlSecondWithBase_Error() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId.longValue())
                                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup()
                                        .withStoreUrl(incorrectlyModifiedUrl))
                ), ExpectedResult.success()
        );

        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId.longValue())
                                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup()
                                        .withStoreUrl(baseUrl))
                ), ExpectedResult.errors(
                        new Notification(6000, Api5ErrorDetails.STORE_URL_MUST_BE_SAME_FOR_RMP_CAMPAIGN)
                )
        );
    }

    @Test
    public void addTwoGroupsInOneRequest_FirstWithCorrectlyModifiedUrlSecondWithBase_Success() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId.longValue())
                                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup()
                                        .withStoreUrl(correctlyModifiedUrl)),
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId.longValue())
                                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup()
                                        .withStoreUrl(baseUrl))
                ), ExpectedResult.success(), ExpectedResult.success()
        );
    }

    @Test
    public void addTwoGroupsInOneRequest_FirstWithIncorrectlyModifiedUrlSecondWithBase_Error() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId.longValue())
                                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup()
                                        .withStoreUrl(incorrectlyModifiedUrl)),
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId.longValue())
                                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup()
                                        .withStoreUrl(baseUrl))
                ), ExpectedResult.errors(
                        new Notification(6000, Api5ErrorDetails.STORE_URL_MUST_BE_SAME_FOR_ALL_GROUPS_IN_RMP_CAMPAIGN)
                ), ExpectedResult.errors(
                        new Notification(6000, Api5ErrorDetails.STORE_URL_MUST_BE_SAME_FOR_ALL_GROUPS_IN_RMP_CAMPAIGN)
                )
        );
    }
}
