package ru.yandex.autotests.direct.api.adgroups.add.mobileappadgroup;

import com.yandex.direct.api.v5.adgroups.TargetCarrierEnum;
import com.yandex.direct.api.v5.adgroups.TargetDeviceTypeEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsMobileContentRecord;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.DeviceTargeting;
import ru.yandex.autotests.directapi.enums.NetworkTargeting;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.direct.db.utils.JooqRecordDifferMatcher.recordDiffer;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by buhter on 20.10.15.
 * https://st.yandex-team.ru/TESTIRT-7178
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Stories(AdGroupsStories.MOBILE)
@Description("Проверка записи в БД")
@Issue("https://st.yandex-team.ru/DIRECT-44780")
public class AddMobileAppAdGroupsDBTest {

    private static final String client = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    static Integer campaignId;
    static Integer shard;

    @BeforeClass
    public static void initTest() {
        shard = api.userSteps.clientFakeSteps().getUserShard(client);
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign().intValue();
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    public void testAddGroupAndVerifyDB() {
        long pid = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId.longValue())
                        .withMobileAppAdGroup(
                                new MobileAppAdGroupAddMap()
                                        .withStoreUrl(MobileAppAdGroupAddMap.DEFAULT_STORE_URL)
                                        .withTargetCarrier(TargetCarrierEnum.WI_FI_ONLY)
                                        .withTargetDeviceTypes(TargetDeviceTypeEnum.DEVICE_TYPE_MOBILE)
                                        .withTargetOperatingSystemVersion(
                                                MobileAppAdGroupAddMap.DEFAULT_TARGET_OPERATING_SYSTEM_VERSION)

                        )
        );
        AdgroupsMobileContentRecord adgroupsMobileContentRecord =
                api.userSteps.getDirectJooqDbSteps().useShardForLogin(client)
                        .mobileContentSteps().getAdgroupsMobileContent(pid);

        AdgroupsMobileContentRecord expectedAdgroupsMobileContentRecord = new AdgroupsMobileContentRecord()
                .setStoreContentHref(MobileAppAdGroupAddMap.DEFAULT_STORE_URL)
                .setNetworkTargeting(NetworkTargeting.WIFI.toString())
                .setDeviceTypeTargeting(DeviceTargeting.PHONE.toString())
                .setPid(pid)
                .setMinOsVersion(MobileAppAdGroupAddMap.DEFAULT_TARGET_OPERATING_SYSTEM_VERSION);
        assertThat("при создание мобильной группы добавилась правильная запсись в таблицу adgroups_mobile_content"
                , adgroupsMobileContentRecord, recordDiffer(expectedAdgroupsMobileContentRecord)
                        .useCompareStrategy(
                                DefaultCompareStrategies.onlyExpectedFields())
        );
    }
}

