package ru.yandex.autotests.direct.api.adgroups.add.mobileappadgroup;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 14.10.15.
 * https://st.yandex-team.ru/TESTIRT-7178
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Stories(AdGroupsStories.MOBILE)
@Description("Дискретная валидация групп РМП")
@Issue("https://st.yandex-team.ru/DIRECT-44780")
public class DiscreteValidationMobileAppAdGroupsTest {

    private static final String client = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    static Integer campaignId;
    static Integer campaignIdElse;

    @BeforeClass
    public static void initTest() {
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign().intValue();
        campaignIdElse = api.userSteps.campaignSteps().addDefaultMobileAppCampaign().intValue();
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    public void addValidAndInvalidMobileAppAdGroups() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId.longValue())
                                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup()),
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId.longValue() + 100000)
                                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup())
                ),
                ExpectedResult.success(),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND))
        );
    }

    @Test
    public void addInvalidAndValidMobileAppAdGroups() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId.longValue() + 100000)
                                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup()),
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId.longValue())
                                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup())
                ),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)),
                ExpectedResult.success()
        );
    }

    @Test
    public void addTwoInvalidMobileAppAdGroups() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId.longValue() + 100000)
                                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup()),
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId.longValue() + 100000)
                                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup())
                ),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND))
        );
    }
}
