package ru.yandex.autotests.direct.api.adgroups.add.mobileappadgroup;

import com.yandex.direct.api.v5.adgroups.TargetDeviceTypeEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Author buhter
 * Date 17.09.15
 * https://st.yandex-team.ru/TESTIRT-7178
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Stories(AdGroupsStories.MOBILE)
@Issue("https://st.yandex-team.ru/DIRECT-44780")
public class MobileAppAdGroupAddInvalidParamsTest {

    private static final String CLIENT = AdGroupsLogins.CLIENT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    static Integer campaignId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign().intValue();
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
    }

    @Test
    public void addWithoutStoreUrl() {
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(Long.valueOf(campaignId))
                                .withMobileAppAdGroup(new MobileAppAdGroupAddMap()
                                        .defaultGroup()
                                        .withStoreUrl(null))),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(MobileAppAdGroupAddMap.STORE_URL)));
    }

    @Test
    public void addWithoutTargetDeviceTypes() {
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(Long.valueOf(campaignId))
                                .withMobileAppAdGroup(new MobileAppAdGroupAddMap()
                                        .defaultGroup()
                                        .withTargetDeviceTypes(new TargetDeviceTypeEnum[]{}))),
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        path(AddRequestMap.AD_GROUPS, AdGroupAddItemMap.MOBILE_APP_AD_GROUP,
                                MobileAppAdGroupAddMap.TARGET_DEVICE_TYPE), 1L));
    }

    @Test
    public void addWithoutTargetCarrier() {
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(Long.valueOf(campaignId))
                                .withMobileAppAdGroup(new MobileAppAdGroupAddMap()
                                        .defaultGroup()
                                        .withTargetCarrier(null))),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(MobileAppAdGroupAddMap.TARGET_CARRIER)));
    }

    @Test
    public void addWithoutTargetOperatingSystemVersion() {
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(Long.valueOf(campaignId))
                                .withMobileAppAdGroup(new MobileAppAdGroupAddMap()
                                        .defaultGroup()
                                        .withTargetOperatingSystemVersion(null))),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(MobileAppAdGroupAddMap.TARGET_OPERATING_SYSTEM_VERSION)));
    }
}
