package ru.yandex.autotests.direct.api.adgroups.add.mobileappadgroup;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MobileAppsRecord;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;

@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Stories(AdGroupsStories.MOBILE)
@Issue("https://st.yandex-team.ru/DIRECT-82971")
@Description("Проверка добавления групп в кампанию, где есть привязанное приложение")
public class MobileAppAdGroupAddNewRmpCampaignHasMobileAppTest {
    private static final String CLIENT = AdGroupsLogins.CLIENT_NEW_RMP;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long clientId;
    private MobileAppsRecord mobileApp;
    private long campaignId;
    private String storeHrefFromMobileAppOfCampaign;

    @Before
    public void before() {
        clientId = Long.valueOf(User.get(CLIENT).getClientID());

        mobileApp = getAnyClientApp();
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT).campaignsSteps()
                .setCampaignMobileAppId(campaignId, mobileApp.getMobileAppId());
        storeHrefFromMobileAppOfCampaign = mobileApp.getStoreHref();

        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @After
    public void after() {
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT).campaignsSteps()
                .unsetCampaignMobileAppId(campaignId);
    }

    @Test
    public void addGroupsToCampaignWithMobileAppWithDifferentStoreUrl_Success() {
        String differentStoreHref = mobileApp.getStoreHref() + "&" + Long.toString(System.currentTimeMillis());
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        createAdGroupAddItemMap(campaignId, differentStoreHref)
                ),
                ExpectedResult.success()
        );
    }

    @Test
    public void addGroupsWithDifferentStoreUrlToCampaignWithMobileApp_Success() {
        String differentStoreHref = storeHrefFromMobileAppOfCampaign + "&" + Long.toString(System.currentTimeMillis());
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        createAdGroupAddItemMap(campaignId, storeHrefFromMobileAppOfCampaign),
                        createAdGroupAddItemMap(campaignId, differentStoreHref)
                ),
                ExpectedResult.success(),
                ExpectedResult.success()
        );
    }

    @Test
    public void addGroupsToCampaignWithMobileAppWithSameStoreUrl_Success() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        createAdGroupAddItemMap(campaignId, storeHrefFromMobileAppOfCampaign)
                ),
                ExpectedResult.success()
        );
    }

    private AdGroupAddItemMap createAdGroupAddItemMap(long campaignId, String storeUrl) {
        return new AdGroupAddItemMap()
                .defaultAdGroupAddItem(campaignId)
                .withMobileAppAdGroup(
                        new MobileAppAdGroupAddMap()
                                .defaultGroup()
                                .withStoreUrl(storeUrl)
                );
    }

    private MobileAppsRecord getAnyClientApp() {
        return api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT).mobileAppsSteps()
                .getMobileAppsByClient(clientId)
                .stream()
                .findFirst()
                .orElseThrow(() -> new AssertionError("Couldn't found any mobile app"));
    }

}
