package ru.yandex.autotests.direct.api.adgroups.add.mobileappadgroup;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MobileAppsRecord;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;

@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Stories(AdGroupsStories.MOBILE)
@Issue("https://st.yandex-team.ru/DIRECT-82971")
@Description("Проверка валидации добавления групп")
public class MobileAppAdGroupAddNewRmpDifferentUlrInRequestTest {
    private static final String CLIENT = AdGroupsLogins.CLIENT_NEW_RMP;

    private static final String STORE_URL1 = "https://itunes.apple.com/ru/app/id111111111?mt=8";
    private static final String STORE_URL2 = "https://itunes.apple.com/ru/app/id222222222?mt=8";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long clientId;
    private String storeHrefFromExistentMobileApp;

    @Before
    public void before() {
        clientId = Long.valueOf(User.get(CLIENT).getClientID());

        // существующее берём чтобы не создавалось новое приложение при успешном добавлении
        storeHrefFromExistentMobileApp = getStoreHrefFromAnyClientMobileApp();

        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    public void addGroupsWithDifferentStoreUrl_ReturnsErrorsForAllGroupsInCampaign() {
        long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        createAdGroupAddItemMap(campaignId, STORE_URL1),
                        createAdGroupAddItemMap(campaignId, STORE_URL1),
                        createAdGroupAddItemMap(campaignId, STORE_URL2)
                ),
                ExpectedResult.errors(new Notification(6000,
                        Api5ErrorDetails.STORE_URL_MUST_BE_SAME_FOR_ALL_GROUPS_IN_RMP_CAMPAIGN)),
                ExpectedResult.errors(new Notification(6000,
                        Api5ErrorDetails.STORE_URL_MUST_BE_SAME_FOR_ALL_GROUPS_IN_RMP_CAMPAIGN)),
                ExpectedResult.errors(new Notification(6000,
                        Api5ErrorDetails.STORE_URL_MUST_BE_SAME_FOR_ALL_GROUPS_IN_RMP_CAMPAIGN))
        );
    }

    @Test
    public void addGroupsWithDifferentStoreUrlToOneCampaignAndWithSameToAnother_DoesntReturnErrorsForCampaignWithGroupsWithSameUrls() {
        // в эту кампанию будем добавлять две группы с одинаковыми ссылками и это должно произойти успешно
        long campaignWithSameUrls = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        // в эту кампанию будем добавлять группы с разными ссылками и для всех этих групп ожидаем ошибку
        long campaignWithDifferentUrls = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        createAdGroupAddItemMap(campaignWithSameUrls, storeHrefFromExistentMobileApp),
                        createAdGroupAddItemMap(campaignWithDifferentUrls, STORE_URL1),
                        createAdGroupAddItemMap(campaignWithSameUrls, storeHrefFromExistentMobileApp),
                        createAdGroupAddItemMap(campaignWithDifferentUrls, STORE_URL2)
                ),
                ExpectedResult.success(),
                ExpectedResult.errors(new Notification(6000,
                        Api5ErrorDetails.STORE_URL_MUST_BE_SAME_FOR_ALL_GROUPS_IN_RMP_CAMPAIGN)),
                ExpectedResult.success(),
                ExpectedResult.errors(new Notification(6000,
                        Api5ErrorDetails.STORE_URL_MUST_BE_SAME_FOR_ALL_GROUPS_IN_RMP_CAMPAIGN))
        );
    }

    private AdGroupAddItemMap createAdGroupAddItemMap(long campaignId, String storeUrl1) {
        return new AdGroupAddItemMap()
                .defaultAdGroupAddItem(campaignId)
                .withMobileAppAdGroup(
                        new MobileAppAdGroupAddMap()
                                .defaultGroup()
                                .withStoreUrl(storeUrl1)
                );
    }

    private String getStoreHrefFromAnyClientMobileApp() {
        return api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT).mobileAppsSteps()
                .getMobileAppsByClient(clientId)
                .stream()
                .map(MobileAppsRecord::getStoreHref)
                .findFirst()
                .orElseThrow(() -> new AssertionError("Couldn't found any mobile app"));
    }
}
