package ru.yandex.autotests.direct.api.adgroups.add.mobileappadgroup;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author buhter
 * Date 17.09.15
 * https://st.yandex-team.ru/TESTIRT-7178
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Stories(AdGroupsStories.MOBILE)
@Issue("https://st.yandex-team.ru/DIRECT-44780")
@RunWith(Parameterized.class)
public class MobileAppAdGroupAddStoreUrlTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String storeUrl;

    @Parameterized.Parameter(1)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "Store URL - {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"https://play.google.com/store/apps/details?id=ru.yandex.searchplugin", ExpectedResult.success()},
                {"http://play.google.com/store/apps/details?id=ru.yandex.searchplugin", ExpectedResult.success()},
                {"https://itunes.apple.com/ru/app/id343200656?mt=8", ExpectedResult.success()},
                {"http://itunes.apple.com/ru/app/id343200656?mt=8", ExpectedResult.success()},
                {"https://itunes.apple.com/ru/album/huamba/id935669226?i=935669243&l=en"
                        , ExpectedResult.errors(new Notification(5004,
                        Api5ErrorDetails.COULD_NOT_RETRIEVE_APPLICATION_INFORMATION))},
                {"play.google.com/store/apps/details?id=ru.yandex.searchplugin"
                        , ExpectedResult.errors(new Notification(5004,
                        Api5ErrorDetails.INCORRECT_LINK))},
                {"http://yandex.ru", ExpectedResult.errors(new Notification(5180,
                        Api5ErrorDetails.UNSUPPORTED_APPLICATION_STORE))},
                {"http://itunes.apple.ru/ru/app/id343200656?mt=8"
                        , ExpectedResult.errors(new Notification(5180,
                        Api5ErrorDetails.UNSUPPORTED_APPLICATION_STORE))},
                {" ", ExpectedResult.errors(new Notification(5000,
                        Api5ErrorDetails.MUST_ENTER_LINK_FOR_APP))},
                {"some_link", ExpectedResult.errors(new Notification(5004,
                        Api5ErrorDetails.INCORRECT_LINK))},
                {"", ExpectedResult.errors(new Notification(5000,
                        Api5ErrorDetails.MUST_ENTER_LINK_FOR_APP))}
        };
        return Arrays.asList(data);
    }

    private Long campaignId;

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
    }

    @Test
    public void addGroupWithStoreUrl() {
        //DIRECT-47567
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(new AdGroupAddItemMap()
                        .defaultAdGroupAddItem(campaignId)
                        .withMobileAppAdGroup(new MobileAppAdGroupAddMap()
                                .defaultGroup()
                                .withStoreUrl(storeUrl)
                        )
                ),
                expectedResult
        );
    }
}

