package ru.yandex.autotests.direct.api.adgroups.add.mobileappadgroup;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.model.bslogs.mobile.OSVersions;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author buhter
 * Date 17.09.15
 * https://st.yandex-team.ru/TESTIRT-7178
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Stories(AdGroupsStories.MOBILE)
@Tag(TagDictionary.TRUNK)
@Issue("https://st.yandex-team.ru/DIRECT-44780")
@RunWith(Parameterized.class)
public class MobileAppAdGroupAddTargetOperatingSystemVersionTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String targetOperatingSystemVersion;

    @Parameterized.Parameter(1)
    public String storeUrl;

    @Parameterized.Parameter(2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters()
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {OSVersions.IOS_VERSIONS[OSVersions.IOS_VERSIONS.length - 1],
                        MobileAppAdGroupAddMap.IOS_STORE_URL,
                        ExpectedResult.success()},
                {OSVersions.ANDRIOD_VERSIONS[0], MobileAppAdGroupAddMap.ANDROID_STORE_URL,
                        ExpectedResult.success()},
                {"не менее " + OSVersions.IOS_VERSIONS[OSVersions.IOS_VERSIONS.length - 1],
                        MobileAppAdGroupAddMap.ANDROID_STORE_URL,
                        ExpectedResult.errors(new Notification(5004,
                        Api5ErrorDetails.OS_VERSION_ENTERED_INCORRECTLY))},
                {OSVersions.IOS_VERSIONS[OSVersions.IOS_VERSIONS.length - 1] + " или выше",
                        MobileAppAdGroupAddMap.IOS_STORE_URL,
                        ExpectedResult.errors(new Notification(5004,
                        Api5ErrorDetails.OS_VERSION_ENTERED_INCORRECTLY))},
                {"asdadasd", MobileAppAdGroupAddMap.ANDROID_STORE_URL,
                        ExpectedResult.errors(new Notification(5004,
                        Api5ErrorDetails.OS_VERSION_ENTERED_INCORRECTLY))},
                {"", MobileAppAdGroupAddMap.ANDROID_STORE_URL,
                        ExpectedResult.errors(new Notification(5000,
                        Api5ErrorDetails.MUST_SET_MINIMUM_OS_VERSION))}
        };
        return Arrays.asList(data);
    }

    private long campaignId;

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
    }

    @Test
    public void AddGroupWithTargetOperatingSystemVersion() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(new AdGroupAddItemMap()
                        .defaultAdGroupAddItem(campaignId)
                        .withMobileAppAdGroup(new MobileAppAdGroupAddMap()
                                .defaultGroup()
                                .withStoreUrl(storeUrl)
                                .withTargetOperatingSystemVersion(targetOperatingSystemVersion)
                        )
                ),
                expectedResult
        );
    }
}

