package ru.yandex.autotests.direct.api.adgroups.add.negativekeywords;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.KeywordsSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

//https://st.yandex-team.ru/TESTIRT-10419
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@Issue("https://st.yandex-team.ru/TESTIRT-10419")
@Description("Добавление невалидной минус-фразы в группу")
@RunWith(Parameterized.class)
public class AddNegativeKeyPhrasesNegativeTest {

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String[] negativeKeyPhrases;

    @Parameterized.Parameter(2)
    public ExpectedResult expectedResultJava;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        String phraseWithSixWords = "медведь перешьет себе теплую шубу на зиму";
        String moreThanMaxLengthNegativeWord =
                RandomStringUtils.randomAlphabetic(KeywordsSteps.MINUS_WORD_MAX_LENGTH + 1);
        String minusPhraseWithMaxLenthWord = "белый " + moreThanMaxLengthNegativeWord;
        String moreThanMaxWordInNegativePhrase = "белый " + phraseWithSixWords;

        ArrayList<String> moreThanMaxLengthNegativePhrasesList = new ArrayList<>();
        int allPhrasesLength = 0;
        while (allPhrasesLength <= (KeywordsSteps.PHRASE_MAX_LENGTH)) {
            allPhrasesLength = allPhrasesLength + KeywordsSteps.MINUS_WORD_MAX_LENGTH;
            moreThanMaxLengthNegativePhrasesList
                    .add(RandomStringUtils.randomAlphabetic(KeywordsSteps.MINUS_WORD_MAX_LENGTH));
        }
        moreThanMaxLengthNegativePhrasesList.add(phraseWithSixWords);

        Object[][] data = new Object[][]{
                {"More than 7 words in negative key phrase ", new String[]{moreThanMaxWordInNegativePhrase},
                        ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetails.NUMBER_OF_WORDS_IN_NEGATIVE_KEYPHRASE_GREATER_THAN,
                                AdGroupAddItemMap.MAX_WORDS_IN_NEGATIVE_KEYPHRASE,
                                moreThanMaxWordInNegativePhrase))},
                {"More than 35 symbol for word in negative key phrase",
                        new String[]{minusPhraseWithMaxLenthWord},
                        ExpectedResult.errors(new Notification(5162,
                                Api5ErrorDetailsJava.LENGTH_OF_NEGATIVE_KEYWORDS_LONGER_THAN,
                                KeywordsSteps.MINUS_WORD_MAX_LENGTH, minusPhraseWithMaxLenthWord))},
                {"More than 4096 symbol for negative key phrase", moreThanMaxLengthNegativePhrasesList.toArray(
                        new String[moreThanMaxLengthNegativePhrasesList.size()]),
                        ExpectedResult.errors(new Notification(5001,
                                Api5ErrorDetails.MINUS_PHRASES_LENGHT_MORE_THAN,
                                AdGroupAddItemMap.MAX_NEGATIVE_KEYWORDS_LENGTH))},
                {"[цветы в горшках", new String[]{"[цветы в горшках"},
                        ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetails.INCORRECT_USE_OF_BRACKETS_IN_MINUS_PHRASE, "[цветы в горшках"))},
                {"цветы+в+горшках", new String[]{"цветы+в+горшках"},
                        ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetails.INCORRECT_USE_OF_SYMBOL_IN_MINUS_PHRASE, "+", "цветы+в+горшках"))},
                {"цветы!в!горшках", new String[]{"цветы!в!горшках"},
                        ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetails.INCORRECT_USE_OF_SYMBOL_IN_MINUS_PHRASE, "!", "цветы!в!горшках"))},
                {"цветы в горшках+", new String[]{"цветы в горшках+"},
                        ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetails.INCORRECT_USE_OF_SYMBOL_IN_MINUS_PHRASE, "+", "цветы в горшках+"))},
                {"цветы в горшках!", new String[]{"цветы в горшках!"},
                        ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetails.INCORRECT_USE_OF_SYMBOL_IN_MINUS_PHRASE, "!", "цветы в горшках!"))},
                {"+ цветы в горшках", new String[]{"+ цветы в горшках"},
                        ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetails.INCORRECT_USE_OF_SYMBOL_IN_MINUS_PHRASE, "+", "+ цветы в горшках"))},
                {"++цветы в горшках", new String[]{"++цветы в горшках"},
                        ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetails.INCORRECT_USE_OF_SYMBOL_IN_MINUS_PHRASE, "+", "++цветы в горшках"))},
                {"-цветы в горшках", new String[]{"-цветы в горшках"},
                        ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetails.INCORRECT_USE_OF_SYMBOL_IN_START_OR_END_OF_MINUS_PHRASE, "-",
                                "-цветы в горшках"))},
                {"цветы в горшках-", new String[]{"цветы в горшках-"},
                        ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetails.INCORRECT_USE_OF_SYMBOL_IN_START_OR_END_OF_MINUS_PHRASE, "-",
                                "цветы в горшках-"))},
                {"цветы в горшках-, цветы в горшках", new String[]{"цветы в горшках-", "цветы в горшках"},
                        ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetails.INCORRECT_USE_OF_SYMBOL_IN_START_OR_END_OF_MINUS_PHRASE, "-",
                                "цветы в горшках-"))},
                {",цветы в горшках", new String[]{",цветы в горшках"},
                        ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetailsJava.MINUS_PHRASES_CAN_ONLY_CONSIST, ",цветы в горшках"))},
                {"цветы в горшках,", new String[]{"цветы в горшках,"},
                        ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetailsJava.MINUS_PHRASES_CAN_ONLY_CONSIST, "цветы в горшках,"))},
                //DIRECT-60720
                {"10.10.10 цветы в горшках", new String[]{"10.10.10 цветы в горшках"},
                        ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetails.MINUS_PHRASES_CANNOT_CONTAIN_MORE_THAN_TWO_NUMBERS,
                                "10.10.10 цветы в горшках"))}
        };
        return Arrays.asList(data);
    }

    private static AdGroupAddItemMap adGroupAddItemMap;

    @BeforeClass
    public static void createCampaign() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupAddItemMap = new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
    }

    @Test
    public void addGroupWithNegativeKeyPhrases() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        adGroupAddItemMap.withNegativeKeywords(negativeKeyPhrases)),
                expectedResultJava);
    }
}
