package ru.yandex.autotests.direct.api.adgroups.add.negativekeywords;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@Issue("https://st.yandex-team.ru/DIRECT-74694")
@Description("Добавление дублирующихся минус-фраз в группу")
public class AddNegativeKeywordsDuplicationTest {
    private static final String[] DUBLICATED_NEGATIVE_KEYWORDS = new String[]{
            "цветы в горшках", "цветы в горшках"};

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private AdGroupAddItemMap adGroupAddItemMap;

    @Before
    public void setUp() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);

        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupAddItemMap = new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId);
    }

    @Test
    public void testGroupWithNegativeKeyPhrases() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        adGroupAddItemMap.withNegativeKeywords(DUBLICATED_NEGATIVE_KEYWORDS)),
                ExpectedResult.success());
    }
}
