package ru.yandex.autotests.direct.api.adgroups.add.negativekeywords;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.KeywordPhraseGenerator;
import ru.yandex.autotests.directapi.steps.banners.KeywordsSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author pavryabov
 * Date 26.08.14
 * https://st.yandex-team.ru/TESTIRT-2022
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddNegativeKeywordsPositiveTest {

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @SuppressWarnings("DefaultAnnotationParam")
    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String[] negativeKeywords;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        String maxLengthNegativeWord = RandomStringUtils.randomAlphabetic(KeywordsSteps.MINUS_WORD_MAX_LENGTH);
        KeywordPhraseGenerator keywordPhraseGenerator =
                new KeywordPhraseGenerator(KeywordsSteps.CYRILLIC_CHARS_NO_SPACE);

        @SuppressWarnings("squid:S1192")
        Object[][] data = new Object[][]{
                {"One russian keyword", new String[]{AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD}},
                {"One english keyword", new String[]{"english"}},
                {"Two negative keywords", new String[]{AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD, "кондиционеры"}},
                {"One keyword with maximum length",
                        keywordPhraseGenerator
                                .generatePhraseWithPlusAndMinusWords(
                                        new Integer[0],
                                        new Integer[]{KeywordsSteps.MINUS_WORD_MAX_LENGTH})
                                .minusWordArray()},
                {"Two keywords with maximum length",
                        keywordPhraseGenerator
                                .generatePhraseWithPlusAndMinusWords(
                                        new Integer[0],
                                        new Integer[]{KeywordsSteps.MINUS_WORD_MAX_LENGTH, KeywordsSteps.MINUS_WORD_MAX_LENGTH})
                                .minusWordArray()},
                {"Many keywords with total length at exactly the limit",
                        keywordPhraseGenerator
                                .generatePhraseWithPlusAndMinusWords(
                                    new Integer[0],
                                    KeywordPhraseGenerator
                                            .minusWordLengthsWithSpecificTotalLength(
                                                    KeywordsSteps.MINUS_WORD_MAX_LENGTH,
                                                    KeywordsSteps.MINUS_WORD_MAX_LENGTH,
                                                    AdGroupAddItemMap.MAX_NEGATIVE_KEYWORDS_LENGTH
                                            )
                                            .toArray(new Integer[0]))
                                .minusWordArray()},
                {"35 symbol + special symbols", new String[]{"["+maxLengthNegativeWord + "]"}},
                {"+test", new String[]{"+test"}},
                {"te-st", new String[]{"te-st"}},
                {"test, te-st", new String[]{"test", "te-st"}},
                {"t e-st", new String[]{"t e-st"}},
                {"!test", new String[]{"!test"}},
                {"te.st", new String[]{"te.st"}},
                {"test.", new String[]{"test."}},
                {"1test", new String[]{"1test"}},
                {"te1st", new String[]{"te1st"}},
                {"test1", new String[]{"test1"}},
                {" test", new String[]{" test"}},
                {"test ", new String[]{"test "}}
        };
        return Arrays.asList(data);
    }

    private static AdGroupAddItemMap adGroupAddItemMap;

    @BeforeClass
    public static void createCampaign() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdGroupsLogins.CLIENT);
        adGroupAddItemMap = new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1623")
    public void addGroupWithNegativeKeywords() {
        //DIRECT-34506
        //DIRECT-34529
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        adGroupAddItemMap.withNegativeKeywords(negativeKeywords)
                ),
                ExpectedResult.success()
        );
    }
}
