package ru.yandex.autotests.direct.api.adgroups.add.textadgroupfeedparams;

import java.util.List;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.AddResponse;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import com.yandex.direct.api.v5.adgroups.TextAdGroupFeedParamsFieldEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.TextAdGroupFeedParamsGetMap;
import ru.yandex.autotests.directapi.model.api5.general.ExceptionNotificationMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Arrays.asList;
import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pashkus on 23.09.2021
 */

@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Stories(AdGroupsStories.DYNAMIC_TEXT)
@Description("Создание групп ДТО")
@Issue("https://st.yandex-team.ru/DIRECT-147863")
public class TextAdGroupWithFeedParamsAddTest {

    private static final String client = AdGroupsLogins.CLIENT;
    private static final Integer FEEDS_NOT_ALLOWED = 10165;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    static Long campaignId;
    static Long feedId;
    static DirectJooqDbSteps jooqDbSteps;
    private TextAdGroupFeedParamsGetMap expected;

    @BeforeClass
    public static void initTest() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();

        int shard = api.userSteps.clientFakeSteps().getUserShard(client);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        feedId = jooqDbSteps.feedsSteps().createDefaultFeed(User.get(client).getClientID());
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    public void addOneGroupFeedIdAndCategoriesWithFeature() {
        setFeature(true);

        List<Long> categoryIds = asList(1L, 2L);
        AddResponse addResponse = api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                                .withTextAdGroupFeedParams(feedId, categoryIds)
                ),
                ExpectedResult.warningsIgnoringDetailsAndMessage(
                        new ExceptionNotificationMap().withCode(FEEDS_NOT_ALLOWED))
        );

        assumeThat("создалась одна группа", addResponse.getAddResults(), iterableWithSize(1));
        long adGroupId = addResponse.getAddResults().get(0).getId();

        GetResponse getResponse =
                api.userSteps.adGroupsSteps().adGroupsGet(getRequestMapForTextAdGroupFeedParams(adGroupId));
        expected = new TextAdGroupFeedParamsGetMap();

        assumeThat("вернулась одна группа", getResponse.getAdGroups(), iterableWithSize(1));
        assertThat("вернулась правильная группа", getResponse.getAdGroups().get(0).getTextAdGroupFeedParams(),
                beanDifferV5(expected.getBean()));
    }

    @Test
    public void addOneGroupWithOnlyFeedIdWithoutFeature() {
        setFeature(false);

        AddResponse addResponse = api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                                .withTextAdGroupFeedParams(feedId)
                ),
                ExpectedResult.warningsIgnoringDetailsAndMessage(
                        new ExceptionNotificationMap().withCode(FEEDS_NOT_ALLOWED))
        );

        assumeThat("создалась одна группа", addResponse.getAddResults(), iterableWithSize(1));
        long adGroupId = addResponse.getAddResults().get(0).getId();

        GetResponse getResponse =
                api.userSteps.adGroupsSteps().adGroupsGet(getRequestMapForTextAdGroupFeedParams(adGroupId));
        expected = new TextAdGroupFeedParamsGetMap();

        assumeThat("вернулась одна группа", getResponse.getAdGroups(), iterableWithSize(1));
        assertThat("вернулась правильная группа", getResponse.getAdGroups().get(0).getTextAdGroupFeedParams(),
                beanDifferV5(expected.getBean()));
    }

    public GetRequestMap getRequestMapForTextAdGroupFeedParams(Long adGroupId) {
        return new GetRequestMap()
                .withSelectionCriteria(
                        new AdGroupsSelectionCriteriaMap()
                                .withIds(adGroupId)
                )
                .withFieldNames(AdGroupFieldEnum.ID)
                .withTextAdGroupFeedParamsFieldNames(
                        TextAdGroupFeedParamsFieldEnum.FEED_ID,
                        TextAdGroupFeedParamsFieldEnum.FEED_CATEGORY_IDS
                );

    }

    private void setFeature(Boolean isEnabled) {
        jooqDbSteps.featuresSteps().setClientFeature(
                Long.valueOf(User.get(client).getClientID()),
                "allow_use_feeds_in_tgo_groups",
                isEnabled);
    }

}
