package ru.yandex.autotests.direct.api.adgroups.delete;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by pavryabov on 16.05.15.
 * https://st.yandex-team.ru/TESTIRT-5468
 */
@Aqua.Test
@Features(AdGroupsFeatures.DELETE)
@Description("проверка SOAP")
public class AdGroupsDeleteSOAPTest {
    private static final String client = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().protocol(ProtocolType.SOAP).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    static Long campaignId;
    @Rule
    public Trashman trasher = new Trashman(api);
    Long id;

    @BeforeClass
    public static void initTest() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        api.as(AdGroupsLogins.CLIENT);
        id = api.userSteps.adGroupsSteps().addGroup(new AdGroupAddItemMap()
                .defaultAdGroupAddItem(campaignId)
                .withNegativeKeywords(AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD)
        );
    }

    @Test
    public void successDeleteTest() {
        api.userSteps.adGroupsSteps().shouldGetResultOnDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(id)),
                ExpectedResult.success(id)
        );
    }

    @Test
    public void deleteWithEmptyRequest() {
        //DIRECT-33530
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsDelete(
                new DeleteRequestMap(),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(DeleteRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    public void deleteWithEmptySelectionCriteria() {
        //DIRECT-33530
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap()),
                // TODO: Сейчас в java для deserialiaze-ии иcпользуется Jackson. Из-за
                // https://github.com/FasterXML/jackson-dataformat-xml/issues/209
                // данный тест не проходит в Jave-е
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(DeleteRequestMap.SELECTION_CRITERIA)));
    }
}
