package ru.yandex.autotests.direct.api.adgroups.delete;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 09.01.15.
 * https://st.yandex-team.ru/TESTIRT-3706
 */
@Aqua.Test
@Features(AdGroupsFeatures.DELETE)
@Stories(ApiStories.UNITS)
public class AdGroupsDeleteUnitsTest {
    //https://st.yandex-team.ru/DIRECT-37648

    private static final String CLIENT = AdGroupsLogins.DELETE_UNITS;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static Long campaignId;

    private static int callCost;
    private static int groupDeleteCost;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);

        callCost = 10;
        groupDeleteCost = 0;
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    public void deleteOneGroup() {
        Long idForDelete = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);
        api.userSteps.adGroupsSteps().adGroupsDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(idForDelete))
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(callCost + groupDeleteCost));
    }

    @Test
    public void deleteTwoGroups() {
        Long idForDelete1 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long idForDelete2 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);
        api.userSteps.adGroupsSteps().adGroupsDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(idForDelete1, idForDelete2))
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(callCost + 2 * groupDeleteCost));
    }
}
