package ru.yandex.autotests.direct.api.adgroups.delete;

import java.util.Arrays;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adgroups.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Author pavryabov
 * Date 10.08.14
 * https://jira.yandex-team.ru/browse/TESTIRT-2022
 */
@Aqua.Test
@Features(AdGroupsFeatures.DELETE)
@Tag(TagDictionary.TRUNK)
public class DeleteInvalidParamsTest {
    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);
    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long campaignId;

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdGroupsLogins.CLIENT);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
    }

    @Test
    public void deleteWithEmptyRequest() {
        //DIRECT-33530
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsDelete(
                new DeleteRequestMap(),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(DeleteRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    public void deleteWithEmptySelectionCriteria() {
        //DIRECT-33530
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap()),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(IdsCriteriaMap.IDS)));
    }

    @Test
    public void deleteWith10001IdsInRequest() {
        //DIRECT-34574
        //DIRECT-33530
        Long id = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long[] ids = new Long[IdsCriteriaMap.IDS_MAX_LENGTH + 1];
        Arrays.fill(ids, id);
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(ids)),
                new Api5Error(4001,
                        Api5ErrorDetailsJava.ARRAY_CANNOT_CONTAIN_MORE_THAN,
                        path(DeleteRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS), 10000L));
    }
}
