package ru.yandex.autotests.direct.api.adgroups.delete;

import java.util.HashMap;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adgroups.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by pavryabov on 11.12.14.
 * https://st.yandex-team.ru/TESTIRT-3706
 */
@Aqua.Test
@Features(AdGroupsFeatures.DELETE)
@Stories(ApiStories.JSON5)
public class DeleteJSONTest {

    private static final String client = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().protocol(ProtocolType.JSON).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    static Long campaignId;
    static Long id;
    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        id = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    public void invalidFieldInSelectionCriteria() {
        //DIRECT-37561
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(IdsCriteriaMap.IDS), new Long[]{id});
        selectionCriteria.put(IdsCriteriaMap.IDS, new Long[]{id});
        request.put(capitalize(DeleteRequestMap.SELECTION_CRITERIA), selectionCriteria);

        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsDelete(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.UNKNOWN_PARAMETER,
                        capitalize(DeleteRequestMap.SELECTION_CRITERIA) + "." + IdsCriteriaMap.IDS));
    }

    @Test
    public void invalidFieldInRequest() {
        //DIRECT-37561
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(IdsCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(DeleteRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(DeleteRequestMap.SELECTION_CRITERIA, selectionCriteria);
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsDelete(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.UNKNOWN_PARAMETER, DeleteRequestMap.SELECTION_CRITERIA));
    }

    @Test
    public void getWithNotArrayInIds() {
        //DIRECT-37558
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(IdsCriteriaMap.IDS), id);
        request.put(capitalize(DeleteRequestMap.SELECTION_CRITERIA), selectionCriteria);
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsDelete(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(DeleteRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS)));
    }

    private static class JSONObject extends HashMap<String, Object> {
    }
}
