package ru.yandex.autotests.direct.api.adgroups.delete;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.yandex.direct.api.v5.general.ActionResult;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 17.02.15.
 */
@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Tag(TagDictionary.NEVER_RUN)
public class DeleteLimitTest {
    // тест - пожиратель баллов. Запускать осторожно и не добавлять в регрессию

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        api.as(AdGroupsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdGroupsLogins.CLIENT);
    }

    @Test
    public void deleteWith10000IdsInRequest() {
        Long id = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long[] ids = new Long[IdsCriteriaMap.IDS_MAX_LENGTH];
        Arrays.fill(ids, id);
        List<ActionResult> results =
                api.userSteps.adGroupsSteps().adGroupsDelete(
                        new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(ids))
                ).getDeleteResults();
        assertThat("количество объектов в ответе верное", results.size(), equalTo(IdsCriteriaMap.IDS_MAX_LENGTH));
        Set<ActionResult> setOfResults = new HashSet<>(results);
        assertThat("в каждом объекте ответа вернулась одна и та же ошибка", setOfResults.size(), equalTo(1));
        ExpectedResult expectedResult = ExpectedResult.errors(new Notification(9800));
        assertThat("в каждом объекте ответа вернлась верная ошибка",
                results.get(0), beanEquals((ActionResult) expectedResult.getBean())
                        .accordingStrategy(expectedResult.getActionResultCompareStrategy()));
    }
}
