package ru.yandex.autotests.direct.api.adgroups.delete.mobileappadgroup;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Author buhter
 * Date 17.09.15
 * https://st.yandex-team.ru/TESTIRT-7178
 */
@Aqua.Test
@Features(AdGroupsFeatures.DELETE)
@Stories(AdGroupsStories.MOBILE)
@Tag(TagDictionary.TRUNK)
@Issue("https://st.yandex-team.ru/DIRECT-44780")
public class MobileAppAdGroupDeleteTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Integer campaignId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        api.as(AdGroupsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign().intValue();
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
    }

    @Test
    public void deleteOneMobileGroup() {
        Long id = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        api.userSteps.adGroupsSteps().shouldGetResultOnDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(id)),
                ExpectedResult.success(id)
        );
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        assertThat("группа удалилась", response.getAdGroups().size(), equalTo(0));
    }

    @Test
    public void deleteTwoMobileGroups() {
        Long id1 = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        Long id2 = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        api.userSteps.adGroupsSteps().shouldGetResultOnDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(id1, id2)),
                ExpectedResult.success(id1),
                ExpectedResult.success(id2)
        );
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(id1, id2)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        assertThat("группы удалились", response.getAdGroups().size(), equalTo(0));
    }

    @Test
    public void deleteTextGroupAndMobileGroup() {
        Long textCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdGroupsLogins.CLIENT);
        Long id1 = api.userSteps.adGroupsSteps().addDefaultGroup(textCampaignId);
        Long id2 = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        api.userSteps.adGroupsSteps().shouldGetResultOnDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(id1, id2)),
                ExpectedResult.success(id1),
                ExpectedResult.success(id2)
        );
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(id1, id2)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        assertThat("группы удалились", response.getAdGroups().size(), equalTo(0));
    }

    @Test
    public void deleteOneMobileGroupAndVerifyInDB() {
        Long id = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        api.userSteps.adGroupsSteps().shouldGetResultOnDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(id)),
                ExpectedResult.success(id)
        );
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        assumeThat("группа удалилась", response.getAdGroups().size(), equalTo(0));
        assertThat("AdgroupsMobileContent в базе удалилась",
                api.userSteps.getDirectJooqDbSteps().useShardForLogin(AdGroupsLogins.CLIENT)
                        .mobileContentSteps().getAdgroupsMobileContent(id), nullValue());
    }

}
