package ru.yandex.autotests.direct.api.adgroups.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.sun.xml.ws.util.StringUtils.capitalize;
import static java.util.stream.Collectors.joining;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 16.05.15.
 * https://st.yandex-team.ru/TESTIRT-5468
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Description("проверка SOAP")
public class AdGroupsGetSOAPTest {

    private static final String client = AdGroupsLogins.CLIENT;

    private static final String GET_REQUEST = "GetRequest";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).protocol(ProtocolType.SOAP).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    Long id;

    @BeforeClass
    public static void initTest() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        api.as(AdGroupsLogins.CLIENT);
        id = api.userSteps.adGroupsSteps().addGroup(new AdGroupAddItemMap()
                .defaultAdGroupAddItem(campaignId)
                .withNegativeKeywords(AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD)
        );
    }

    @Test
    public void successGetTest() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(AdGroupFieldEnum.NAME)
        );
        assumeThat("AdGroups.get вернул одну группу", response.getAdGroups(), hasSize(1));
    }

    @Test
    public void getWithoutSelectionCriteria() {
        //DIRECT-33530
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsGet(
                new GetRequestMap()
                        .withFieldNames(AdGroupFieldEnum.CAMPAIGN_ID),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(GetRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    public void getWithoutFieldNames() {
        //DIRECT-33530
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withCampaignIds(campaignId)
                        ),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(GetRequestMap.FIELD_NAMES)));
    }

    @Test
    public void getWithInvalidFieldInFieldNames() {
        //DIRECT-33530
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(campaignId)
                        )
                        .withFieldNames(
                                AdGroupFieldEnum.CAMPAIGN_ID.value().toLowerCase()
                        ),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        capitalize(GetRequestMap.FIELD_NAMES),
                        Arrays.stream(AdGroupFieldEnum.values())
                                .map(AdGroupFieldEnum::value)
                                .collect(joining(", "))));
    }

    @Test
    public void getWithValidAndInvalidFieldsInFieldNames() {
        //DIRECT-33530
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(campaignId)
                        )
                        .withFieldNames(
                                AdGroupFieldEnum.ID.value(),
                                AdGroupFieldEnum.CAMPAIGN_ID.value().toLowerCase()
                        ),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        capitalize(GetRequestMap.FIELD_NAMES),
                        Arrays.stream(AdGroupFieldEnum.values())
                                .map(AdGroupFieldEnum::value)
                                .collect(joining(", "))));
    }

    @Test
    public void getWithEmptyRequest() {
        //DIRECT-33530
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsGet(
                new GetRequestMap(),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(GetRequestMap.FIELD_NAMES)));
    }
}
