package ru.yandex.autotests.direct.api.adgroups.get;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 09.01.15.
 * https://st.yandex-team.ru/TESTIRT-3706
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Stories(ApiStories.UNITS)
public class AdGroupsGetUnitsTest {
    //https://st.yandex-team.ru/DIRECT-37648

    private static final String agency = AdGroupsLogins.AGENCY_UNITS;
    private static final String subclient = AdGroupsLogins.SUBCLIENT_UNITS;
    private static final String client = AdGroupsLogins.GET_UNITS;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    static Long campaignId;
    static Long id1;
    static Long id2;

    final int GET_COST = 15;
    final int GET_COST_GROUP = 1;
    final int GENERAL_ERROR_COST = 50;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(subclient);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        id1 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        id2 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(subclient);
    }

    @Test
    public void getOneGroup() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(id1)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(GET_COST + GET_COST_GROUP));
    }

    @Test
    public void getTwoGroups() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(id1, id2)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(GET_COST + 2 * GET_COST_GROUP));
    }

    @Test
    public void checkWithdrawUnitsFromOperatorForRequestError() {
        api.as(agency);
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(agency);
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdGroupsSelectionCriteriaMap().withIds(id1)
                ),
                subclient,
                new Api5Error(
                        8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        StringUtils.capitalize(GetRequestMap.FIELD_NAMES)));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(agency);
        assertThat("списались баллы с оператора", unitsBefore - unitsAfter, equalTo(GENERAL_ERROR_COST));
    }

}
