package ru.yandex.autotests.direct.api.adgroups.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Author pavryabov
 * Date 08.10.14
 * https://st.yandex-team.ru/TESTIRT-2022
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Stories(AdGroupsStories.AUTHORIZATION)
@RunWith(Parameterized.class)
public class AgencyCheckRightsToGetTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String client = AdGroupsLogins.CLIENT;
    private static final String agency = AdGroupsLogins.AGENCY;
    private static final String agencyRep = AdGroupsLogins.AGENCY_REP;
    private static final String agencyRepCl = AdGroupsLogins.AGENCY_REP_CL;
    private static final String subclient = AdGroupsLogins.SUBCLIENT;
    private static final String subclientElse = AdGroupsLogins.SUBCLIENT_ELSE;

    static Long clientCampaignId;
    static Long subclientCampaignId;
    static Long subclientElseCampaignId;
    static Long clientId;
    static Long subclientId;
    static Long subclientElseId;

    @Parameterized.Parameter(0)
    public String loginForAuthorization;

    @Parameterized.Parameter(1)
    public String loginForHeader;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {agency, subclient},
                {agencyRep, subclient},
                {agencyRepCl, subclient},
                {subclient, null}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createNotMineCampaign() {
        api.userSteps.clientFakeSteps().defaultAPI(subclient);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclient, ShardNumbers.DEFAULT_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclientElse, ShardNumbers.DEFAULT_SHARD);
        clientCampaignId = api.as(client).userSteps.campaignSteps().addDefaultTextCampaign(client);
        clientId = api.userSteps.adGroupsSteps().addDefaultGroup(clientCampaignId);
        subclientCampaignId = api.as(agency).userSteps.campaignSteps().addDefaultTextCampaign(subclient);
        subclientId = api.userSteps.adGroupsSteps().addDefaultGroup(subclientCampaignId, subclient);
        subclientElseCampaignId = api.as(agency).userSteps.campaignSteps().addDefaultTextCampaign(subclientElse);
        subclientElseId = api.userSteps.adGroupsSteps().addDefaultGroup(subclientElseCampaignId, subclientElse);

    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(loginForAuthorization);
    }

    @Test
    public void callGetWithSubclientCampaign() {
        GetResponse response = api.as(loginForAuthorization).userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdGroupsSelectionCriteriaMap().withCampaignIds(subclientCampaignId))
                        .withFieldNames(AdGroupFieldEnum.CAMPAIGN_ID),
                loginForHeader
        );
        assertThat("вернулось правильное количество групп", response.getAdGroups().size(), equalTo(1));
    }

    @Test
    public void callGetWithCampaignsOfBothSubclients() {
        GetResponse response = api.as(loginForAuthorization).userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdGroupsSelectionCriteriaMap().withCampaignIds(
                                subclientCampaignId,
                                subclientElseCampaignId
                        ))
                        .withFieldNames(AdGroupFieldEnum.CAMPAIGN_ID),
                loginForHeader
        );
        assertThat("вернулось правильное количество групп", response.getAdGroups().size(), equalTo(1));
    }

    @Test
    public void callGetWithSubclientElseCampaign() {
        GetResponse response = api.as(loginForAuthorization).userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdGroupsSelectionCriteriaMap().withCampaignIds(subclientElseCampaignId))
                        .withFieldNames(AdGroupFieldEnum.CAMPAIGN_ID),
                loginForHeader
        );
        assertThat("вернулось правильное количество групп", response.getAdGroups().size(), equalTo(0));
    }

    @Test
    public void callGetWithClientCampaign() {
        GetResponse response = api.as(loginForAuthorization).userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdGroupsSelectionCriteriaMap().withCampaignIds(clientCampaignId))
                        .withFieldNames(AdGroupFieldEnum.CAMPAIGN_ID),
                loginForHeader
        );
        assertThat("вернулось правильное количество групп", response.getAdGroups().size(), equalTo(0));
    }
}
