package ru.yandex.autotests.direct.api.adgroups.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
/**
 * Author pavryabov
 * Date 08.10.14
 * https://st.yandex-team.ru/TESTIRT-2022
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Stories(AdGroupsStories.AUTHORIZATION)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class CheckReadRightsToClientWithDifferentOwnersTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String oldAgency = Logins.AGENCY_YE_DEFAULT;
    private static final String agencyElse = AdGroupsLogins.AGENCY_SHARD2;
    private static final String manager = Logins.MANAGER_DEFAULT;
    private static final String subclientWithServiceCampaigns = Logins.CLIENT_FREE_YE_DEFAULT;
    Long campaignId;
    Long id;

    @Parameterized.Parameter(0)
    public String agency;

    @Parameterized.Parameter(1)
    public String subclient;

    @Parameterized.Parameter(2)
    public String secondOwner;

    @Parameterized.Parameter(3)
    public Integer expectedAdGroupAmount;

    @Parameterized.Parameters(name = "agency = {0}, subclient = {1}, secondOwner = {2}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {oldAgency, subclientWithServiceCampaigns, manager, 1} //DIRECT-64601
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void reshardUsers() {
        api.userSteps.clientFakeSteps().reshardUserWithLock(agencyElse, ShardNumbers.EXTRA_SHARD);
    }

    @Before
    public void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
        campaignId = api.as(secondOwner).userSteps.campaignSteps().addDefaultTextCampaign(subclient);
        id = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, subclient);
    }

    @Test
    public void checkRightsToRead() {
        //DIRECT-35645
        GetResponse response = api.as(agency).userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdGroupsSelectionCriteriaMap().withCampaignIds(campaignId))
                        .withFieldNames(AdGroupFieldEnum.CAMPAIGN_ID),
                subclient
        );
        assertThat("вернулось правильное количество групп", response.getAdGroups().size(), equalTo(expectedAdGroupAmount));
    }
}
