package ru.yandex.autotests.direct.api.adgroups.get;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.AdGroupGetItem;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.model.common.RegionIDValues;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.*;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by onotole on 9/27/16.
 * https://st.yandex-team.ru/DIRECT-56940
 */
@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Description("проверяем, что для adGroup из удаленного региона регион сменился на список составляющих его частей")
@RunWith(Parameterized.class)
@Tag(TagDictionary.NEVER_RUN)
public class CheckRemovedRegionsTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String login;

    @Parameterized.Parameter(2)
    public Long adGroupId;

    @Parameterized.Parameter(3)
    public Long[] expectedRegionId;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> testData() {
        return Arrays.asList(new Object[][] {
                {"20526 Юг/Украина/СНГ/Евразия/Земля", "vitaod", 1736135L, RegionIDValues.UKRAINIAN_SOUTH_PARTS},
                {"980 Страны Балтии/Европа/Евразия/Земля", "webinar-promo", 1894552736L, RegionIDValues.BALTIC_PARTS},
                {"1004 Ближний Восток/Азия/Евразия/Земля", "mir-de-lux", 16821735L, RegionIDValues.NEAR_EAST_PARTS}
        });
    }

    @Test
    public void getAdGroupWithDeletedRegion() {
        api.as(Logins.SUPER_LOGIN, login);
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                    .withSelectionCriteria(
                            new AdGroupsSelectionCriteriaMap()
                                .withIds(adGroupId)
                    )
                    .withFieldNames(AdGroupFieldEnum.REGION_IDS)
        );
        List<AdGroupGetItem> adGroupGetItemList = response.getAdGroups();
        assumeThat("Запрошенный adGroup найден", adGroupGetItemList.size(), equalTo(1));

        List<Long> regions = adGroupGetItemList.get(0).getRegionIds();
        Collections.sort(regions);
        List<Long> expectedRegionsList = new ArrayList<>(Arrays.asList(expectedRegionId));
        Collections.sort(expectedRegionsList);

        assertThat("Вернулись подрегионы удаленного региона", regions, equalTo(expectedRegionsList));
    }
}
