package ru.yandex.autotests.direct.api.adgroups.get;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import org.junit.*;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

/**
 * Created by pavryabov on 05.12.14.
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Stories(AdGroupsStories.AUTHORIZATION)
@RunWith(Parameterized.class)
public class ClientAuthorizationNegativeTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String client = AdGroupsLogins.CLIENT;
    private static final String clientRep = AdGroupsLogins.CLIENT_REP;
    private static final String otherClient = AdGroupsLogins.CLIENT_SHARD2;
    private static final String clientNoAccessToAPI = AdGroupsLogins.SUBCLIENT_ELSE;

    @Parameterized.Parameter(0)
    public String loginForAuthorization;

    @Parameterized.Parameter(1)
    public String loginForHeader;

    @Parameterized.Parameter(2)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}, loginForHeader = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {client, otherClient,
                        new Api5Error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN)},
                {clientRep, otherClient,
                        new Api5Error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN)},
                {//DIRECT-43260
                        clientNoAccessToAPI, null,
                        new Api5Error(3000, Api5ErrorDetails.ACCOUNT_BLOCKED)}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void reshardUsers() {
        api.userSteps.clientFakeSteps().disableAPI(clientNoAccessToAPI);
        api.userSteps.clientFakeSteps().reshardUserWithLock(otherClient, ShardNumbers.EXTRA_SHARD);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(loginForAuthorization);
    }

    @Test
    public void callGetWithLoginInHeader() {
        //DIRECT-35003
        api.as(loginForAuthorization).userSteps.adGroupsSteps().expectErrorOnAdGroupsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdGroupsSelectionCriteriaMap().withCampaignIds(123L))
                        .withFieldNames(AdGroupFieldEnum.CAMPAIGN_ID),
                loginForHeader,
                expectedError
        );
    }
}
